/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.adapter;

import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.strategy.encrypt.ShardingEncryptorEngine;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.executor.ForceExecuteCallback;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.executor.ForceExecuteTemplate;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset.ShardingResultSetMetaData;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.statement.ShardingPreparedStatement;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.statement.ShardingStatement;
import org.apache.shardingsphere.shardingjdbc.jdbc.unsupported.AbstractUnsupportedOperationResultSet;

public abstract class AbstractResultSetAdapter
extends AbstractUnsupportedOperationResultSet {
    private final List<ResultSet> resultSets;
    private final Statement statement;
    private boolean closed;
    private final ForceExecuteTemplate<ResultSet> forceExecuteTemplate = new ForceExecuteTemplate();

    public AbstractResultSetAdapter(List<ResultSet> resultSets, Statement statement) {
        Preconditions.checkArgument((!resultSets.isEmpty() ? 1 : 0) != 0);
        this.resultSets = resultSets;
        this.statement = statement;
    }

    @Override
    public final ResultSetMetaData getMetaData() throws SQLException {
        return new ShardingResultSetMetaData(this.resultSets.get(0).getMetaData(), this.getShardingRule());
    }

    private ShardingRule getShardingRule() {
        return this.statement instanceof ShardingPreparedStatement ? ((ShardingPreparedStatement)this.statement).getConnection().getShardingContext().getShardingRule() : ((ShardingStatement)this.statement).getConnection().getShardingContext().getShardingRule();
    }

    protected final ShardingEncryptorEngine getShardingEncryptorEngine() {
        return this.getShardingRule().getShardingEncryptorEngine();
    }

    @Override
    public final int findColumn(String columnLabel) throws SQLException {
        return this.resultSets.get(0).findColumn(columnLabel);
    }

    @Override
    public final void close() throws SQLException {
        this.closed = true;
        this.forceExecuteTemplate.execute(this.resultSets, new ForceExecuteCallback<ResultSet>(){

            @Override
            public void execute(ResultSet resultSet) throws SQLException {
                resultSet.close();
            }
        });
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final void setFetchDirection(final int direction) throws SQLException {
        this.forceExecuteTemplate.execute(this.resultSets, new ForceExecuteCallback<ResultSet>(){

            @Override
            public void execute(ResultSet resultSet) throws SQLException {
                resultSet.setFetchDirection(direction);
            }
        });
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        return this.resultSets.get(0).getFetchDirection();
    }

    @Override
    public final void setFetchSize(final int rows) throws SQLException {
        this.forceExecuteTemplate.execute(this.resultSets, new ForceExecuteCallback<ResultSet>(){

            @Override
            public void execute(ResultSet resultSet) throws SQLException {
                resultSet.setFetchSize(rows);
            }
        });
    }

    @Override
    public final int getFetchSize() throws SQLException {
        return this.resultSets.get(0).getFetchSize();
    }

    @Override
    public final int getType() throws SQLException {
        return this.resultSets.get(0).getType();
    }

    @Override
    public final int getConcurrency() throws SQLException {
        return this.resultSets.get(0).getConcurrency();
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.resultSets.get(0).getWarnings();
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.forceExecuteTemplate.execute(this.resultSets, new ForceExecuteCallback<ResultSet>(){

            @Override
            public void execute(ResultSet resultSet) throws SQLException {
                resultSet.clearWarnings();
            }
        });
    }

    public List<ResultSet> getResultSets() {
        return this.resultSets;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }
}

