/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.connection;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.AbstractConnectionAdapter;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.ShardingContext;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.statement.ShardingPreparedStatement;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.statement.ShardingStatement;
import org.apache.shardingsphere.transaction.ShardingTransactionManagerEngine;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class ShardingConnection
extends AbstractConnectionAdapter {
    private final Map<String, DataSource> dataSourceMap;
    private final ShardingContext shardingContext;

    public ShardingConnection(Map<String, DataSource> dataSourceMap, ShardingContext shardingContext, ShardingTransactionManagerEngine shardingTransactionManagerEngine, TransactionType transactionType) {
        super(shardingTransactionManagerEngine, transactionType);
        this.dataSourceMap = dataSourceMap;
        this.shardingContext = shardingContext;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getCachedConnections().isEmpty() ? this.shardingContext.getCachedDatabaseMetaData() : ((Connection)this.getCachedConnections().values().iterator().next()).getMetaData();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) {
        return new ShardingPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        return new ShardingPreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) {
        return new ShardingPreparedStatement(this, sql, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return new ShardingPreparedStatement(this, sql, 1);
    }

    @Override
    public Statement createStatement() {
        return new ShardingStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new ShardingStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new ShardingStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    protected boolean isOnlyLocalTransactionValid() {
        return false;
    }

    @Override
    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public ShardingContext getShardingContext() {
        return this.shardingContext;
    }
}

