/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.shardingsphere.api.config.encryptor.EncryptRuleConfiguration;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.metadata.table.ColumnMetaData;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.metadata.table.TableMetaData;
import org.apache.shardingsphere.core.parse.EncryptSQLParsingEngine;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.connection.EncryptConnection;
import org.apache.shardingsphere.shardingjdbc.jdbc.unsupported.AbstractUnsupportedOperationDataSource;

public class EncryptDataSource
extends AbstractUnsupportedOperationDataSource
implements AutoCloseable {
    private final DataSource dataSource;
    private final EncryptRule encryptRule;
    private final DatabaseType databaseType;
    private final EncryptSQLParsingEngine encryptSQLParsingEngine;
    private PrintWriter logWriter = new PrintWriter(System.out);

    public EncryptDataSource(DataSource dataSource, EncryptRuleConfiguration encryptRuleConfiguration) {
        this.dataSource = dataSource;
        this.encryptRule = new EncryptRule(encryptRuleConfiguration);
        this.databaseType = this.getDatabaseType();
        this.encryptSQLParsingEngine = new EncryptSQLParsingEngine(this.databaseType, this.encryptRule, this.createEncryptTableMetaData());
    }

    private ShardingTableMetaData createEncryptTableMetaData() {
        LinkedHashMap<String, TableMetaData> tables = new LinkedHashMap<String, TableMetaData>();
        try (Connection connection = this.dataSource.getConnection();){
            for (String each : this.encryptRule.getEncryptTableNames()) {
                if (!this.isTableExist(connection, each)) continue;
                tables.put(each, new TableMetaData(this.getColumnMetaDataList(connection, each)));
            }
        }
        return new ShardingTableMetaData(tables);
    }

    private boolean isTableExist(Connection connection, String tableName) throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), null, tableName, null);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    private List<ColumnMetaData> getColumnMetaDataList(Connection connection, String tableName) throws SQLException {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        Collection<String> primaryKeys = this.getPrimaryKeys(connection, tableName);
        try (ResultSet resultSet = connection.getMetaData().getColumns(connection.getCatalog(), null, tableName, "%");){
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                String columnType = resultSet.getString("TYPE_NAME");
                result.add(new ColumnMetaData(columnName, columnType, primaryKeys.contains(columnName)));
            }
        }
        return result;
    }

    private Collection<String> getPrimaryKeys(Connection connection, String tableName) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(connection.getCatalog(), null, tableName);){
            while (resultSet.next()) {
                result.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        return result;
    }

    private DatabaseType getDatabaseType() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseType databaseType = DatabaseType.valueFrom((String)connection.getMetaData().getDatabaseProductName());
            return databaseType;
        }
    }

    @Override
    public EncryptConnection getConnection() {
        return new EncryptConnection(this.dataSource.getConnection(), this.encryptRule, this.databaseType, this.encryptSQLParsingEngine);
    }

    @Override
    public Connection getConnection(String username, String password) {
        return this.getConnection();
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger("global");
    }

    @Override
    public void close() {
        try {
            Method method = this.dataSource.getClass().getDeclaredMethod("close", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this.dataSource, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public EncryptRule getEncryptRule() {
        return this.encryptRule;
    }

    public EncryptSQLParsingEngine getEncryptSQLParsingEngine() {
        return this.encryptSQLParsingEngine;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }
}

