/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.AbstractDataSourceAdapter;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.ShardingContext;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.connection.ShardingConnection;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.MasterSlaveDataSource;
import org.apache.shardingsphere.transaction.core.TransactionTypeHolder;

public class ShardingDataSource
extends AbstractDataSourceAdapter {
    private final ShardingContext shardingContext;

    public ShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule) throws SQLException {
        this(dataSourceMap, shardingRule, new Properties());
    }

    public ShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, Properties props) throws SQLException {
        super(dataSourceMap);
        this.checkDataSourceType(dataSourceMap);
        this.shardingContext = new ShardingContext(this.getDataSourceMap(), shardingRule, this.getDatabaseType(), props);
    }

    private void checkDataSourceType(Map<String, DataSource> dataSourceMap) {
        for (DataSource each : dataSourceMap.values()) {
            Preconditions.checkArgument((!(each instanceof MasterSlaveDataSource) ? 1 : 0) != 0, (Object)"Initialized data sources can not be master-slave data sources.");
        }
    }

    @Override
    public final ShardingConnection getConnection() {
        return new ShardingConnection(this.getDataSourceMap(), this.shardingContext, this.getShardingTransactionManagerEngine(), TransactionTypeHolder.get());
    }

    @Override
    public final void close() throws Exception {
        super.close();
        this.shardingContext.close();
    }

    public ShardingContext getShardingContext() {
        return this.shardingContext;
    }
}

