/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.metadata;

import java.sql.DatabaseMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.metadata.AdaptedDatabaseMetaData;

public final class CachedDatabaseMetaData
extends AdaptedDatabaseMetaData {
    private final String url;
    private final String userName;
    private final String databaseProductName;
    private final String databaseProductVersion;
    private final String driverName;
    private final String driverVersion;
    private final int driverMajorVersion;
    private final int driverMinorVersion;
    private final int databaseMajorVersion;
    private final int databaseMinorVersion;
    private final int jdbcMajorVersion;
    private final int jdbcMinorVersion;
    private final boolean isReadOnly;
    private final boolean allProceduresAreCallable;
    private final boolean allTablesAreSelectable;
    private final boolean nullsAreSortedHigh;
    private final boolean nullsAreSortedLow;
    private final boolean nullsAreSortedAtStart;
    private final boolean nullsAreSortedAtEnd;
    private final boolean usesLocalFiles;
    private final boolean usesLocalFilePerTable;
    private final boolean supportsMixedCaseIdentifiers;
    private final boolean storesUpperCaseIdentifiers;
    private final boolean storesLowerCaseIdentifiers;
    private final boolean storesMixedCaseIdentifiers;
    private final boolean supportsMixedCaseQuotedIdentifiers;
    private final boolean storesUpperCaseQuotedIdentifiers;
    private final boolean storesLowerCaseQuotedIdentifiers;
    private final boolean storesMixedCaseQuotedIdentifiers;
    private final String identifierQuoteString;
    private final String sqlKeywords;
    private final String numericFunctions;
    private final String stringFunctions;
    private final String systemFunctions;
    private final String timeDateFunctions;
    private final String searchStringEscape;
    private final String extraNameCharacters;
    private final boolean supportsAlterTableWithAddColumn;
    private final boolean supportsAlterTableWithDropColumn;
    private final boolean supportsColumnAliasing;
    private final boolean nullPlusNonNullIsNull;
    private final boolean supportsConvert;
    private final boolean supportsTableCorrelationNames;
    private final boolean supportsDifferentTableCorrelationNames;
    private final boolean supportsExpressionsInOrderBy;
    private final boolean supportsOrderByUnrelated;
    private final boolean supportsGroupBy;
    private final boolean supportsGroupByUnrelated;
    private final boolean supportsGroupByBeyondSelect;
    private final boolean supportsLikeEscapeClause;
    private final boolean supportsMultipleResultSets;
    private final boolean supportsMultipleTransactions;
    private final boolean supportsNonNullableColumns;
    private final boolean supportsMinimumSQLGrammar;
    private final boolean supportsCoreSQLGrammar;
    private final boolean supportsExtendedSQLGrammar;
    private final boolean supportsANSI92EntryLevelSQL;
    private final boolean supportsANSI92IntermediateSQL;
    private final boolean supportsANSI92FullSQL;
    private final boolean supportsIntegrityEnhancementFacility;
    private final boolean supportsOuterJoins;
    private final boolean supportsFullOuterJoins;
    private final boolean supportsLimitedOuterJoins;
    private final String schemaTerm;
    private final String procedureTerm;
    private final String catalogTerm;
    private final boolean isCatalogAtStart;
    private final String catalogSeparator;
    private final boolean supportsSchemasInDataManipulation;
    private final boolean supportsSchemasInProcedureCalls;
    private final boolean supportsSchemasInTableDefinitions;
    private final boolean supportsSchemasInIndexDefinitions;
    private final boolean supportsSchemasInPrivilegeDefinitions;
    private final boolean supportsCatalogsInDataManipulation;
    private final boolean supportsCatalogsInProcedureCalls;
    private final boolean supportsCatalogsInTableDefinitions;
    private final boolean supportsCatalogsInIndexDefinitions;
    private final boolean supportsCatalogsInPrivilegeDefinitions;
    private final boolean supportsPositionedDelete;
    private final boolean supportsPositionedUpdate;
    private final boolean supportsSelectForUpdate;
    private final boolean supportsStoredProcedures;
    private final boolean supportsSubqueriesInComparisons;
    private final boolean supportsSubqueriesInIns;
    private final boolean supportsSubqueriesInQuantifieds;
    private final boolean supportsCorrelatedSubqueries;
    private final boolean supportsUnion;
    private final boolean supportsUnionAll;
    private final boolean supportsOpenCursorsAcrossCommit;
    private final boolean supportsOpenCursorsAcrossRollback;
    private final boolean supportsOpenStatementsAcrossCommit;
    private final boolean supportsOpenStatementsAcrossRollback;
    private final int maxBinaryLiteralLength;
    private final int maxCharLiteralLength;
    private final int maxColumnNameLength;
    private final int maxColumnsInGroupBy;
    private final int maxColumnsInIndex;
    private final int maxColumnsInOrderBy;
    private final int maxColumnsInSelect;
    private final int maxColumnsInTable;
    private final int maxConnections;
    private final int maxCursorNameLength;
    private final int maxIndexLength;
    private final int maxSchemaNameLength;
    private final int maxProcedureNameLength;
    private final int maxCatalogNameLength;
    private final int maxRowSize;
    private final boolean doesMaxRowSizeIncludeBlobs;
    private final int maxStatementLength;
    private final int maxStatements;
    private final int maxTableNameLength;
    private final int maxTablesInSelect;
    private final int maxUserNameLength;
    private final int defaultTransactionIsolation;
    private final boolean supportsTransactions;
    private final boolean supportsDataDefinitionAndDataManipulationTransactions;
    private final boolean supportsDataManipulationTransactionsOnly;
    private final boolean dataDefinitionCausesTransactionCommit;
    private final boolean dataDefinitionIgnoredInTransactions;
    private final boolean supportsBatchUpdates;
    private final boolean supportsSavepoints;
    private final boolean supportsNamedParameters;
    private final boolean supportsMultipleOpenResults;
    private final boolean supportsGetGeneratedKeys;
    private final int resultSetHoldability;
    private final int sqlStateType;
    private final boolean locatorsUpdateCopy;
    private final boolean supportsStatementPooling;
    private final boolean supportsStoredFunctionsUsingCallSyntax;
    private final boolean autoCommitFailureClosesAllResultSets;
    private final RowIdLifetime rowIdLifetime;
    private final boolean generatedKeyAlwaysReturned;

    public CachedDatabaseMetaData(DatabaseMetaData databaseMetaData, Map<String, DataSource> dataSourceMap, ShardingRule shardingRule) throws SQLException {
        super(dataSourceMap, shardingRule);
        this.url = databaseMetaData.getURL();
        this.userName = databaseMetaData.getUserName();
        this.databaseProductName = databaseMetaData.getDatabaseProductName();
        this.databaseProductVersion = databaseMetaData.getDatabaseProductVersion();
        this.driverName = databaseMetaData.getDriverName();
        this.driverVersion = databaseMetaData.getDriverVersion();
        this.driverMajorVersion = databaseMetaData.getDriverMajorVersion();
        this.driverMinorVersion = databaseMetaData.getDriverMinorVersion();
        this.databaseMajorVersion = databaseMetaData.getDatabaseMajorVersion();
        this.databaseMinorVersion = databaseMetaData.getDatabaseMinorVersion();
        this.jdbcMajorVersion = databaseMetaData.getJDBCMajorVersion();
        this.jdbcMinorVersion = databaseMetaData.getJDBCMinorVersion();
        this.isReadOnly = databaseMetaData.isReadOnly();
        this.allProceduresAreCallable = databaseMetaData.allProceduresAreCallable();
        this.allTablesAreSelectable = databaseMetaData.allTablesAreSelectable();
        this.nullsAreSortedHigh = databaseMetaData.nullsAreSortedHigh();
        this.nullsAreSortedLow = databaseMetaData.nullsAreSortedLow();
        this.nullsAreSortedAtStart = databaseMetaData.nullsAreSortedAtStart();
        this.nullsAreSortedAtEnd = databaseMetaData.nullsAreSortedAtEnd();
        this.usesLocalFiles = databaseMetaData.usesLocalFiles();
        this.usesLocalFilePerTable = databaseMetaData.usesLocalFilePerTable();
        this.supportsMixedCaseIdentifiers = databaseMetaData.supportsMixedCaseIdentifiers();
        this.storesUpperCaseIdentifiers = databaseMetaData.storesUpperCaseIdentifiers();
        this.storesLowerCaseIdentifiers = databaseMetaData.storesLowerCaseIdentifiers();
        this.storesMixedCaseIdentifiers = databaseMetaData.storesMixedCaseIdentifiers();
        this.supportsMixedCaseQuotedIdentifiers = databaseMetaData.supportsMixedCaseQuotedIdentifiers();
        this.storesUpperCaseQuotedIdentifiers = databaseMetaData.storesUpperCaseQuotedIdentifiers();
        this.storesLowerCaseQuotedIdentifiers = databaseMetaData.storesLowerCaseQuotedIdentifiers();
        this.storesMixedCaseQuotedIdentifiers = databaseMetaData.storesMixedCaseQuotedIdentifiers();
        this.identifierQuoteString = databaseMetaData.getIdentifierQuoteString();
        this.sqlKeywords = databaseMetaData.getSQLKeywords();
        this.numericFunctions = databaseMetaData.getNumericFunctions();
        this.stringFunctions = databaseMetaData.getStringFunctions();
        this.systemFunctions = databaseMetaData.getSystemFunctions();
        this.timeDateFunctions = databaseMetaData.getTimeDateFunctions();
        this.searchStringEscape = databaseMetaData.getSearchStringEscape();
        this.extraNameCharacters = databaseMetaData.getExtraNameCharacters();
        this.supportsAlterTableWithAddColumn = databaseMetaData.supportsAlterTableWithAddColumn();
        this.supportsAlterTableWithDropColumn = databaseMetaData.supportsAlterTableWithDropColumn();
        this.supportsColumnAliasing = databaseMetaData.supportsColumnAliasing();
        this.nullPlusNonNullIsNull = databaseMetaData.nullPlusNonNullIsNull();
        this.supportsConvert = databaseMetaData.supportsConvert();
        this.supportsTableCorrelationNames = databaseMetaData.supportsTableCorrelationNames();
        this.supportsDifferentTableCorrelationNames = databaseMetaData.supportsDifferentTableCorrelationNames();
        this.supportsExpressionsInOrderBy = databaseMetaData.supportsExpressionsInOrderBy();
        this.supportsOrderByUnrelated = databaseMetaData.supportsOrderByUnrelated();
        this.supportsGroupBy = databaseMetaData.supportsGroupBy();
        this.supportsGroupByUnrelated = databaseMetaData.supportsGroupByUnrelated();
        this.supportsGroupByBeyondSelect = databaseMetaData.supportsGroupByBeyondSelect();
        this.supportsLikeEscapeClause = databaseMetaData.supportsLikeEscapeClause();
        this.supportsMultipleResultSets = databaseMetaData.supportsMultipleResultSets();
        this.supportsMultipleTransactions = databaseMetaData.supportsMultipleTransactions();
        this.supportsNonNullableColumns = databaseMetaData.supportsNonNullableColumns();
        this.supportsMinimumSQLGrammar = databaseMetaData.supportsMinimumSQLGrammar();
        this.supportsCoreSQLGrammar = databaseMetaData.supportsCoreSQLGrammar();
        this.supportsExtendedSQLGrammar = databaseMetaData.supportsExtendedSQLGrammar();
        this.supportsANSI92EntryLevelSQL = databaseMetaData.supportsANSI92EntryLevelSQL();
        this.supportsANSI92IntermediateSQL = databaseMetaData.supportsANSI92IntermediateSQL();
        this.supportsANSI92FullSQL = databaseMetaData.supportsANSI92FullSQL();
        this.supportsIntegrityEnhancementFacility = databaseMetaData.supportsIntegrityEnhancementFacility();
        this.supportsOuterJoins = databaseMetaData.supportsOuterJoins();
        this.supportsFullOuterJoins = databaseMetaData.supportsFullOuterJoins();
        this.supportsLimitedOuterJoins = databaseMetaData.supportsLimitedOuterJoins();
        this.schemaTerm = databaseMetaData.getSchemaTerm();
        this.procedureTerm = databaseMetaData.getProcedureTerm();
        this.catalogTerm = databaseMetaData.getCatalogTerm();
        this.isCatalogAtStart = databaseMetaData.isCatalogAtStart();
        this.catalogSeparator = databaseMetaData.getCatalogSeparator();
        this.supportsSchemasInDataManipulation = databaseMetaData.supportsSchemasInDataManipulation();
        this.supportsSchemasInProcedureCalls = databaseMetaData.supportsSchemasInProcedureCalls();
        this.supportsSchemasInTableDefinitions = databaseMetaData.supportsSchemasInTableDefinitions();
        this.supportsSchemasInIndexDefinitions = databaseMetaData.supportsSchemasInIndexDefinitions();
        this.supportsSchemasInPrivilegeDefinitions = databaseMetaData.supportsSchemasInPrivilegeDefinitions();
        this.supportsCatalogsInDataManipulation = databaseMetaData.supportsCatalogsInDataManipulation();
        this.supportsCatalogsInProcedureCalls = databaseMetaData.supportsCatalogsInProcedureCalls();
        this.supportsCatalogsInTableDefinitions = databaseMetaData.supportsCatalogsInTableDefinitions();
        this.supportsCatalogsInIndexDefinitions = databaseMetaData.supportsCatalogsInIndexDefinitions();
        this.supportsCatalogsInPrivilegeDefinitions = databaseMetaData.supportsCatalogsInPrivilegeDefinitions();
        this.supportsPositionedDelete = databaseMetaData.supportsPositionedDelete();
        this.supportsPositionedUpdate = databaseMetaData.supportsPositionedUpdate();
        this.supportsSelectForUpdate = databaseMetaData.supportsSelectForUpdate();
        this.supportsStoredProcedures = databaseMetaData.supportsStoredProcedures();
        this.supportsSubqueriesInComparisons = databaseMetaData.supportsSubqueriesInComparisons();
        this.supportsSubqueriesInIns = databaseMetaData.supportsSubqueriesInIns();
        this.supportsSubqueriesInQuantifieds = databaseMetaData.supportsSubqueriesInQuantifieds();
        this.supportsCorrelatedSubqueries = databaseMetaData.supportsCorrelatedSubqueries();
        this.supportsUnion = databaseMetaData.supportsUnion();
        this.supportsUnionAll = databaseMetaData.supportsUnionAll();
        this.supportsOpenCursorsAcrossCommit = databaseMetaData.supportsOpenCursorsAcrossCommit();
        this.supportsOpenCursorsAcrossRollback = databaseMetaData.supportsOpenCursorsAcrossRollback();
        this.supportsOpenStatementsAcrossCommit = databaseMetaData.supportsOpenStatementsAcrossCommit();
        this.supportsOpenStatementsAcrossRollback = databaseMetaData.supportsOpenStatementsAcrossRollback();
        this.maxBinaryLiteralLength = databaseMetaData.getMaxBinaryLiteralLength();
        this.maxCharLiteralLength = databaseMetaData.getMaxCharLiteralLength();
        this.maxColumnNameLength = databaseMetaData.getMaxColumnNameLength();
        this.maxColumnsInGroupBy = databaseMetaData.getMaxColumnsInGroupBy();
        this.maxColumnsInIndex = databaseMetaData.getMaxColumnsInIndex();
        this.maxColumnsInOrderBy = databaseMetaData.getMaxColumnsInOrderBy();
        this.maxColumnsInSelect = databaseMetaData.getMaxColumnsInSelect();
        this.maxColumnsInTable = databaseMetaData.getMaxColumnsInTable();
        this.maxConnections = databaseMetaData.getMaxConnections();
        this.maxCursorNameLength = databaseMetaData.getMaxCursorNameLength();
        this.maxIndexLength = databaseMetaData.getMaxIndexLength();
        this.maxSchemaNameLength = databaseMetaData.getMaxSchemaNameLength();
        this.maxProcedureNameLength = databaseMetaData.getMaxProcedureNameLength();
        this.maxCatalogNameLength = databaseMetaData.getMaxCatalogNameLength();
        this.maxRowSize = databaseMetaData.getMaxRowSize();
        this.doesMaxRowSizeIncludeBlobs = databaseMetaData.doesMaxRowSizeIncludeBlobs();
        this.maxStatementLength = databaseMetaData.getMaxStatementLength();
        this.maxStatements = databaseMetaData.getMaxStatements();
        this.maxTableNameLength = databaseMetaData.getMaxTableNameLength();
        this.maxTablesInSelect = databaseMetaData.getMaxTablesInSelect();
        this.maxUserNameLength = databaseMetaData.getMaxUserNameLength();
        this.defaultTransactionIsolation = databaseMetaData.getDefaultTransactionIsolation();
        this.supportsTransactions = databaseMetaData.supportsTransactions();
        this.supportsDataDefinitionAndDataManipulationTransactions = databaseMetaData.supportsDataDefinitionAndDataManipulationTransactions();
        this.supportsDataManipulationTransactionsOnly = databaseMetaData.supportsDataManipulationTransactionsOnly();
        this.dataDefinitionCausesTransactionCommit = databaseMetaData.dataDefinitionCausesTransactionCommit();
        this.dataDefinitionIgnoredInTransactions = databaseMetaData.dataDefinitionIgnoredInTransactions();
        this.supportsBatchUpdates = databaseMetaData.supportsBatchUpdates();
        this.supportsSavepoints = databaseMetaData.supportsSavepoints();
        this.supportsNamedParameters = databaseMetaData.supportsNamedParameters();
        this.supportsMultipleOpenResults = databaseMetaData.supportsMultipleOpenResults();
        this.supportsGetGeneratedKeys = databaseMetaData.supportsGetGeneratedKeys();
        this.resultSetHoldability = databaseMetaData.getResultSetHoldability();
        this.sqlStateType = databaseMetaData.getSQLStateType();
        this.locatorsUpdateCopy = databaseMetaData.locatorsUpdateCopy();
        this.supportsStatementPooling = databaseMetaData.supportsStatementPooling();
        this.supportsStoredFunctionsUsingCallSyntax = databaseMetaData.supportsStoredFunctionsUsingCallSyntax();
        this.autoCommitFailureClosesAllResultSets = databaseMetaData.autoCommitFailureClosesAllResultSets();
        this.rowIdLifetime = this.getRowIdLifetimeFromOriginMetaData(databaseMetaData);
        this.generatedKeyAlwaysReturned = this.isGeneratedKeyAlwaysReturned(databaseMetaData);
    }

    private RowIdLifetime getRowIdLifetimeFromOriginMetaData(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return databaseMetaData.getRowIdLifetime();
        }
        catch (SQLFeatureNotSupportedException ignore) {
            return RowIdLifetime.ROWID_UNSUPPORTED;
        }
    }

    private boolean isGeneratedKeyAlwaysReturned(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return databaseMetaData.generatedKeyAlwaysReturned();
        }
        catch (AbstractMethodError ignore) {
            return false;
        }
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public String getDriverVersion() {
        return this.driverVersion;
    }

    @Override
    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    @Override
    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    @Override
    public int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    @Override
    public int getJDBCMajorVersion() {
        return this.jdbcMajorVersion;
    }

    @Override
    public int getJDBCMinorVersion() {
        return this.jdbcMinorVersion;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return this.allProceduresAreCallable;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return this.allTablesAreSelectable;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return this.nullsAreSortedHigh;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return this.nullsAreSortedLow;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return this.nullsAreSortedAtStart;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return this.nullsAreSortedAtEnd;
    }

    @Override
    public boolean usesLocalFiles() {
        return this.usesLocalFiles;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return this.usesLocalFilePerTable;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return this.supportsMixedCaseIdentifiers;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return this.storesUpperCaseIdentifiers;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return this.storesLowerCaseIdentifiers;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return this.storesMixedCaseIdentifiers;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return this.supportsMixedCaseQuotedIdentifiers;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return this.storesUpperCaseQuotedIdentifiers;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return this.storesLowerCaseQuotedIdentifiers;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return this.storesMixedCaseQuotedIdentifiers;
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    @Override
    public String getSQLKeywords() {
        return this.sqlKeywords;
    }

    @Override
    public String getNumericFunctions() {
        return this.numericFunctions;
    }

    @Override
    public String getStringFunctions() {
        return this.stringFunctions;
    }

    @Override
    public String getSystemFunctions() {
        return this.systemFunctions;
    }

    @Override
    public String getTimeDateFunctions() {
        return this.timeDateFunctions;
    }

    @Override
    public String getSearchStringEscape() {
        return this.searchStringEscape;
    }

    @Override
    public String getExtraNameCharacters() {
        return this.extraNameCharacters;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return this.supportsAlterTableWithAddColumn;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return this.supportsAlterTableWithDropColumn;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return this.supportsColumnAliasing;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return this.nullPlusNonNullIsNull;
    }

    @Override
    public boolean supportsConvert() {
        return this.supportsConvert;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return this.supportsConvert;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return this.supportsTableCorrelationNames;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return this.supportsDifferentTableCorrelationNames;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return this.supportsExpressionsInOrderBy;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return this.supportsOrderByUnrelated;
    }

    @Override
    public boolean supportsGroupBy() {
        return this.supportsGroupBy;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return this.supportsGroupByUnrelated;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return this.supportsGroupByBeyondSelect;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return this.supportsLikeEscapeClause;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return this.supportsMultipleResultSets;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return this.supportsMultipleTransactions;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return this.supportsNonNullableColumns;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return this.supportsMinimumSQLGrammar;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return this.supportsCoreSQLGrammar;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return this.supportsExtendedSQLGrammar;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return this.supportsANSI92EntryLevelSQL;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return this.supportsANSI92IntermediateSQL;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return this.supportsANSI92FullSQL;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return this.supportsIntegrityEnhancementFacility;
    }

    @Override
    public boolean supportsOuterJoins() {
        return this.supportsOuterJoins;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return this.supportsFullOuterJoins;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return this.supportsLimitedOuterJoins;
    }

    @Override
    public String getSchemaTerm() {
        return this.schemaTerm;
    }

    @Override
    public String getProcedureTerm() {
        return this.procedureTerm;
    }

    @Override
    public String getCatalogTerm() {
        return this.catalogTerm;
    }

    @Override
    public boolean isCatalogAtStart() {
        return this.isCatalogAtStart;
    }

    @Override
    public String getCatalogSeparator() {
        return this.catalogSeparator;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return this.supportsSchemasInDataManipulation;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return this.supportsSchemasInProcedureCalls;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return this.supportsSchemasInTableDefinitions;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return this.supportsSchemasInIndexDefinitions;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return this.supportsSchemasInPrivilegeDefinitions;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return this.supportsCatalogsInDataManipulation;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return this.supportsCatalogsInProcedureCalls;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return this.supportsCatalogsInTableDefinitions;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return this.supportsCatalogsInIndexDefinitions;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return this.supportsCatalogsInPrivilegeDefinitions;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return this.supportsPositionedDelete;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return this.supportsPositionedUpdate;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return this.supportsSelectForUpdate;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return this.supportsStoredProcedures;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return this.supportsSubqueriesInComparisons;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return this.supportsSubqueriesInComparisons;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return this.supportsSubqueriesInIns;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return this.supportsSubqueriesInQuantifieds;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return this.supportsCorrelatedSubqueries;
    }

    @Override
    public boolean supportsUnion() {
        return this.supportsUnion;
    }

    @Override
    public boolean supportsUnionAll() {
        return this.supportsUnionAll;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return this.supportsOpenCursorsAcrossCommit;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return this.supportsOpenCursorsAcrossRollback;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return this.supportsOpenStatementsAcrossCommit;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return this.supportsOpenStatementsAcrossRollback;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return this.maxBinaryLiteralLength;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return this.maxCharLiteralLength;
    }

    @Override
    public int getMaxColumnNameLength() {
        return this.maxColumnNameLength;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return this.maxColumnsInGroupBy;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return this.maxColumnsInIndex;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return this.maxColumnsInOrderBy;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return this.maxColumnsInSelect;
    }

    @Override
    public int getMaxColumnsInTable() {
        return this.maxColumnsInTable;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public int getMaxCursorNameLength() {
        return this.maxCursorNameLength;
    }

    @Override
    public int getMaxIndexLength() {
        return this.maxIndexLength;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return this.maxSchemaNameLength;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return this.maxProcedureNameLength;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return this.maxCatalogNameLength;
    }

    @Override
    public int getMaxRowSize() {
        return this.maxRowSize;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return this.doesMaxRowSizeIncludeBlobs;
    }

    @Override
    public int getMaxStatementLength() {
        return this.maxStatementLength;
    }

    @Override
    public int getMaxStatements() {
        return this.maxStatements;
    }

    @Override
    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    @Override
    public int getMaxTablesInSelect() {
        return this.maxTablesInSelect;
    }

    @Override
    public int getMaxUserNameLength() {
        return this.maxUserNameLength;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    @Override
    public boolean supportsTransactions() {
        return this.supportsTransactions;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return this.supportsDataDefinitionAndDataManipulationTransactions;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return this.supportsDataManipulationTransactionsOnly;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return this.dataDefinitionCausesTransactionCommit;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return this.dataDefinitionIgnoredInTransactions;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }

    @Override
    public boolean supportsSavepoints() {
        return this.supportsSavepoints;
    }

    @Override
    public boolean supportsNamedParameters() {
        return this.supportsNamedParameters;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return this.supportsMultipleOpenResults;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return this.supportsGetGeneratedKeys;
    }

    @Override
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    @Override
    public int getSQLStateType() {
        return this.sqlStateType;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return this.locatorsUpdateCopy;
    }

    @Override
    public boolean supportsStatementPooling() {
        return this.supportsStatementPooling;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return this.supportsStoredFunctionsUsingCallSyntax;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return this.autoCommitFailureClosesAllResultSets;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return this.rowIdLifetime;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return this.generatedKeyAlwaysReturned;
    }
}

