/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset;

import java.beans.ConstructorProperties;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.shardingsphere.core.parse.old.parser.constant.DerivedColumn;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.WrapperAdapter;

public final class ShardingResultSetMetaData
extends WrapperAdapter
implements ResultSetMetaData {
    private final ResultSetMetaData resultSetMetaData;
    private final ShardingRule shardingRule;

    @Override
    public int getColumnCount() throws SQLException {
        int result = 0;
        for (int columnIndex = 1; columnIndex <= this.resultSetMetaData.getColumnCount(); ++columnIndex) {
            if (DerivedColumn.isDerivedColumn((String)this.resultSetMetaData.getColumnLabel(columnIndex))) continue;
            ++result;
        }
        return result;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.resultSetMetaData.isAutoIncrement(column);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.resultSetMetaData.isCaseSensitive(column);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.resultSetMetaData.isSearchable(column);
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.resultSetMetaData.isCurrency(column);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.resultSetMetaData.isNullable(column);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.resultSetMetaData.isSigned(column);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.resultSetMetaData.getColumnDisplaySize(column);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.resultSetMetaData.getColumnLabel(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.resultSetMetaData.getColumnName(column);
    }

    @Override
    public String getSchemaName(int column) {
        return "logic_db";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.resultSetMetaData.getPrecision(column);
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.resultSetMetaData.getScale(column);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        String actualTableName = this.resultSetMetaData.getTableName(column);
        return this.shardingRule.getLogicTableNames(actualTableName).isEmpty() ? actualTableName : (String)this.shardingRule.getLogicTableNames(actualTableName).iterator().next();
    }

    @Override
    public String getCatalogName(int column) {
        return "logic_db";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.resultSetMetaData.getColumnType(column);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.resultSetMetaData.getColumnTypeName(column);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.resultSetMetaData.isReadOnly(column);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.resultSetMetaData.isWritable(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.resultSetMetaData.isDefinitelyWritable(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.resultSetMetaData.getColumnClassName(column);
    }

    @ConstructorProperties(value={"resultSetMetaData", "shardingRule"})
    public ShardingResultSetMetaData(ResultSetMetaData resultSetMetaData, ShardingRule shardingRule) {
        this.resultSetMetaData = resultSetMetaData;
        this.shardingRule = shardingRule;
    }
}

