/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Token;

public class Response
extends Message {
    private final CoAP.ResponseCode code;
    private volatile Long rtt;

    public static Response createResponse(Request receivedRequest, CoAP.ResponseCode code) {
        if (receivedRequest.getSourceContext() == null) {
            throw new IllegalArgumentException("received request must contain a source context.");
        }
        Response response = new Response(code);
        response.setDestinationContext(receivedRequest.getSourceContext());
        return response;
    }

    public Response(CoAP.ResponseCode code) {
        this.code = code;
    }

    public CoAP.ResponseCode getCode() {
        return this.code;
    }

    @Override
    public int getRawCode() {
        return this.code.value;
    }

    public String toString() {
        return this.toTracingString(this.getCode().toString());
    }

    public Long getRTT() {
        return this.rtt;
    }

    public void setRTT(long rtt) {
        this.rtt = rtt;
    }

    public void ensureToken(Token token) {
        Token current = this.getToken();
        if (current == null) {
            this.setToken(token);
        } else if (!current.equals((Object)token)) {
            throw new IllegalArgumentException("token mismatch! (" + (Object)((Object)current) + "!=" + (Object)((Object)token) + ")");
        }
    }

    public boolean isNotification() {
        return this.getOptions().hasObserve();
    }

    public boolean hasBlockOption() {
        return this.getOptions().hasBlock1() || this.getOptions().hasBlock2();
    }

    public final boolean isError() {
        return this.isClientError() || this.isServerError();
    }

    public final boolean isClientError() {
        return CoAP.ResponseCode.isClientError(this.code);
    }

    public final boolean isServerError() {
        return CoAP.ResponseCode.isServerError(this.code);
    }
}

