/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack.congestioncontrol;

import java.net.InetSocketAddress;
import org.eclipse.californium.core.network.stack.CongestionControlLayer;
import org.eclipse.californium.core.network.stack.RemoteEndpoint;
import org.eclipse.californium.elements.config.Configuration;

public class LinuxRto
extends CongestionControlLayer {
    public LinuxRto(String tag, Configuration config) {
        super(tag, config);
    }

    @Override
    protected RemoteEndpoint createRemoteEndpoint(InetSocketAddress remoteSocketAddress) {
        return new LinuxRemoteEndpoint(remoteSocketAddress, this.defaultReliabilityLayerParameters.getAckTimeout(), this.defaultReliabilityLayerParameters.getNstart());
    }

    private static class LinuxRemoteEndpoint
    extends RemoteEndpoint {
        private long SRTT;
        private long RTTVAR;
        private long mdev;
        private long mdev_max;

        private LinuxRemoteEndpoint(InetSocketAddress remoteAddress, int ackTimeout, int nstart) {
            super(remoteAddress, ackTimeout, nstart, true);
        }

        private void initializeRTOEstimators(long measuredRTT) {
            long RTT;
            this.SRTT = RTT = measuredRTT;
            this.mdev = RTT / 2L;
            this.RTTVAR = this.mdev_max = Math.max(this.mdev, 50L);
            long newRTO = this.SRTT + 4L * this.RTTVAR;
            this.printLinuxStats();
            this.updateRTO(newRTO);
        }

        private void updateEstimator(long measuredRTT) {
            long RTT = measuredRTT;
            this.SRTT += Math.round(0.125 * (double)(RTT - this.SRTT));
            this.mdev = RTT < this.SRTT - this.mdev ? Math.round(0.96875 * (double)this.mdev + 0.03125 * (double)Math.abs(RTT - this.SRTT)) : Math.round(0.75 * (double)this.mdev) + Math.round(0.25 * (double)Math.abs(RTT - this.SRTT));
            if (this.mdev > this.mdev_max) {
                this.mdev_max = this.mdev;
                if (this.mdev_max > this.RTTVAR) {
                    this.RTTVAR = this.mdev_max;
                }
            }
            if (this.mdev_max < this.RTTVAR) {
                this.RTTVAR = Math.round(0.75 * (double)this.RTTVAR + 0.25 * (double)this.mdev_max);
            }
            this.mdev_max = 50L;
            long newRTO = this.SRTT + 4L * this.RTTVAR;
            this.printLinuxStats();
            this.updateRTO(newRTO);
        }

        @Override
        public synchronized void processRttMeasurement(RemoteEndpoint.RtoType rtoType, long measuredRTT) {
            if (rtoType != RemoteEndpoint.RtoType.STRONG) {
                return;
            }
            if (this.initialRto()) {
                this.initializeRTOEstimators(measuredRTT);
            } else {
                this.updateEstimator(measuredRTT);
            }
        }

        private void printLinuxStats() {
            LOGGER.trace("SRTT: {}, RTTVAR: {}, mdev: {}, mdev_max: {}", new Object[]{this.SRTT, this.RTTVAR, this.mdev, this.mdev_max});
        }
    }
}

