/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.KeyToken;
import org.eclipse.californium.core.observe.ObserveManager;
import org.eclipse.californium.core.observe.ObservingEndpoint;
import org.eclipse.californium.core.server.resources.ObservableResource;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.ClockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserveRelation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObserveRelation.class);
    private final long checkIntervalTime;
    private final int checkIntervalCount;
    private final ObserveManager manager;
    private final ObservableResource resource;
    private final Exchange exchange;
    private final CoAP.Type requestType;
    private final InetSocketAddress source;
    private final KeyToken key;
    private Response recentControlNotification;
    private Response nextControlNotification;
    private volatile ObservingEndpoint endpoint;
    private volatile boolean established;
    private volatile boolean canceled;
    private long interestCheckTimer = ClockUtil.nanoRealtime();
    private int interestCheckCounter = 1;

    @Deprecated
    public ObserveRelation(ObservingEndpoint endpoint, Resource resource, Exchange exchange) {
        this(null, (ObservableResource)((Object)resource), exchange);
        this.setEndpoint(endpoint);
    }

    public ObserveRelation(ObserveManager manager, ObservableResource resource, Exchange exchange) {
        if (manager == null) {
            throw new NullPointerException("Observe manager must not be null!");
        }
        if (resource == null) {
            throw new NullPointerException("Observing resource must not be null!");
        }
        if (exchange == null) {
            throw new NullPointerException("Exchange must not be null!");
        }
        this.manager = manager;
        this.resource = resource;
        this.exchange = exchange;
        this.requestType = exchange.getRequest().getType();
        Configuration config = exchange.getEndpoint().getConfig();
        this.checkIntervalTime = config.get(CoapConfig.NOTIFICATION_CHECK_INTERVAL_TIME, TimeUnit.NANOSECONDS);
        this.checkIntervalCount = (Integer)config.get((BasicDefinition)CoapConfig.NOTIFICATION_CHECK_INTERVAL_COUNT);
        Request request = exchange.getRequest();
        this.source = request.getSourceContext().getPeerAddress();
        this.key = ObserveRelation.getKeyToken(exchange);
        LOGGER.debug("Observe-relation, checks every {}ns or {} notifications.", (Object)this.checkIntervalTime, (Object)this.checkIntervalCount);
    }

    public void setEndpoint(ObservingEndpoint endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("Observing endpoint must not be null!");
        }
        this.endpoint = endpoint;
        this.endpoint.addObserveRelation(this);
        this.exchange.setRelation(this);
    }

    public boolean isEstablished() {
        return this.established;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEstablished() {
        boolean fail;
        ObserveRelation observeRelation = this;
        synchronized (observeRelation) {
            fail = this.canceled;
            if (!fail) {
                this.established = true;
            }
        }
        if (fail) {
            throw new IllegalStateException(String.format("Could not establish observe relation %s with %s, already canceled (%s)!", this.getKey(), this.resource.getURI(), this.exchange));
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Deprecated
    public void cleanup() {
        this.cancel();
    }

    public void reject() {
        if (this.manager != null) {
            this.manager.onRejectedNotification(this);
        } else {
            this.cancel();
        }
    }

    public void cancel() {
        this.cancel(true);
    }

    public void cancelAll() {
        this.endpoint.cancelAll();
    }

    @Deprecated
    public void notifyObservers() {
        ((Resource)((Object)this.resource)).handleRequest(this.exchange);
    }

    @Deprecated
    public Resource getResource() {
        return (Resource)((Object)this.resource);
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public InetSocketAddress getSource() {
        return this.source;
    }

    public ObservingEndpoint getEndpoint() {
        return this.endpoint;
    }

    public CoAP.Type getObserveType() {
        CoAP.Type observeType = this.resource.getObserveType();
        if (observeType == null) {
            observeType = this.requestType;
        }
        if (observeType != CoAP.Type.CON && !this.check()) {
            return CoAP.Type.NON;
        }
        return CoAP.Type.CON;
    }

    public State onResponse(Response response) {
        boolean canceled = this.isCanceled();
        if (canceled) {
            return State.CANCELED;
        }
        if (this.isEstablished()) {
            this.exchange.retransmitResponse();
            if (response.isSuccess()) {
                response.getOptions().setObserve(this.resource.getNotificationSequenceNumber());
            }
            return State.ESTABILSHED;
        }
        boolean established = false;
        if (response.isSuccess()) {
            this.setEstablished();
            this.resource.addObserveRelation(this);
            boolean bl = established = !this.isCanceled();
        }
        if (established) {
            response.getOptions().setObserve(this.resource.getNotificationSequenceNumber());
            return State.INIT;
        }
        return State.CANCELED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check() {
        boolean check;
        long now = ClockUtil.nanoRealtime();
        ObserveRelation observeRelation = this;
        synchronized (observeRelation) {
            boolean bl = check = ++this.interestCheckCounter >= this.checkIntervalCount;
            if (check) {
                this.interestCheckTimer = now;
                this.interestCheckCounter = 0;
            }
        }
        if (check) {
            LOGGER.trace("Observe-relation check, {} notifications reached.", (Object)this.checkIntervalCount);
            return check;
        }
        observeRelation = this;
        synchronized (observeRelation) {
            boolean bl = check = now - this.interestCheckTimer - this.checkIntervalTime > 0L;
            if (check) {
                this.interestCheckTimer = now;
                this.interestCheckCounter = 0;
            }
        }
        if (check) {
            LOGGER.trace("Observe-relation check, {}s interval reached.", (Object)TimeUnit.NANOSECONDS.toSeconds(this.checkIntervalTime));
        }
        return check;
    }

    public boolean isPostponedNotification(Response response) {
        if (ObserveRelation.isInTransit(this.recentControlNotification)) {
            LOGGER.trace("in transit {}", (Object)this.recentControlNotification);
            if (this.nextControlNotification != null) {
                if (!this.nextControlNotification.isNotification()) {
                    return true;
                }
                this.nextControlNotification.onTransferComplete();
            }
            this.nextControlNotification = response;
            return true;
        }
        this.recentControlNotification = response;
        this.nextControlNotification = null;
        this.onSend(response);
        return false;
    }

    public Response getNextNotification(Response response, boolean acknowledged) {
        Response next = null;
        if (this.recentControlNotification == response) {
            next = this.nextControlNotification;
            if (next != null) {
                this.recentControlNotification = next;
                this.nextControlNotification = null;
                this.onSend(next);
            } else if (acknowledged) {
                this.recentControlNotification = null;
                this.nextControlNotification = null;
            }
        }
        return next;
    }

    @Deprecated
    public void send(Response response) {
        this.onSend(response);
    }

    public void onSend(Response response) {
        if (!response.isNotification()) {
            this.cancel(false);
        }
    }

    public KeyToken getKeyToken() {
        return this.key;
    }

    @Deprecated
    public String getKey() {
        return this.key.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(boolean complete) {
        boolean cancel = false;
        boolean established = false;
        ObserveRelation observeRelation = this;
        synchronized (observeRelation) {
            if (!this.canceled) {
                this.canceled = true;
                established = this.established;
                this.established = false;
                cancel = true;
            }
        }
        if (cancel) {
            LOGGER.debug("Canceling observe relation {} with {} ({})", new Object[]{this.getKey(), this.resource.getURI(), this.exchange});
            if (established) {
                this.resource.removeObserveRelation(this);
            }
            if (this.manager != null) {
                this.manager.removeObserveRelation(this);
            } else {
                this.endpoint.removeObserveRelation(this);
            }
            if (complete) {
                this.exchange.executeComplete();
            }
        }
    }

    public static State onResponse(ObserveRelation relation, Response response) {
        boolean noNotification;
        State result = State.NONE;
        if (relation != null) {
            result = relation.onResponse(response);
        }
        boolean bl = noNotification = result == State.NONE || result == State.CANCELED;
        if (response.isNotification() && (!response.isSuccess() || noNotification)) {
            LOGGER.warn("Application notification, not longer observing, remove observe-option {}", (Object)response);
            response.getOptions().removeObserve();
        }
        return result;
    }

    public static KeyToken getKeyToken(Exchange exchange) {
        Request request = exchange.getRequest();
        return new KeyToken(request.getToken(), request.getSourceContext().getPeerAddress());
    }

    private static boolean isInTransit(Response response) {
        if (response == null || !response.isConfirmable()) {
            return false;
        }
        return !response.isAcknowledged() && !response.isTimedOut() && !response.isRejected();
    }

    public static enum State {
        NONE,
        INIT,
        ESTABILSHED,
        CANCELED;

    }
}

