/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.Arrays;
import java.util.Random;
import org.eclipse.californium.elements.util.StringUtil;

public class Bytes {
    public static final byte[] EMPTY = new byte[0];
    private final byte[] bytes;
    private final int hash;

    public Bytes(byte[] bytes) {
        this(bytes, 255, false);
    }

    public Bytes(byte[] bytes, int maxLength, boolean copy) {
        if (bytes == null) {
            throw new NullPointerException("bytes must not be null");
        }
        if (bytes.length > maxLength) {
            throw new IllegalArgumentException("bytes length must be between 0 and " + maxLength + " inclusive");
        }
        this.bytes = copy ? Arrays.copyOf(bytes, bytes.length) : bytes;
        this.hash = Arrays.hashCode(bytes);
    }

    public String toString() {
        return "BYTES=" + this.getAsString();
    }

    public final int hashCode() {
        return this.hash;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bytes other = (Bytes)obj;
        if (this.hash != other.hash) {
            return false;
        }
        return Arrays.equals(this.bytes, other.bytes);
    }

    public final byte[] getBytes() {
        return this.bytes;
    }

    public final String getAsString() {
        return StringUtil.byteArray2Hex(this.bytes);
    }

    public final boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public final int length() {
        return this.bytes.length;
    }

    public static byte[] createBytes(Random generator, int size) {
        byte[] byteArray = new byte[size];
        generator.nextBytes(byteArray);
        return byteArray;
    }

    public static byte[] concatenate(Bytes a, Bytes b) {
        return Bytes.concatenate(a.getBytes(), b.getBytes());
    }

    public static byte[] concatenate(byte[] a, byte[] b) {
        int lengthA = a.length;
        int lengthB = b.length;
        byte[] concat = new byte[lengthA + lengthB];
        System.arraycopy(a, 0, concat, 0, lengthA);
        System.arraycopy(b, 0, concat, lengthA, lengthB);
        return concat;
    }

    public static void clear(byte[] data) {
        Arrays.fill(data, (byte)0);
    }
}

