/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.artifacts;

public final class TargetPlatformFilter {
    private final CapabilityPattern scopePattern;
    private final FilterAction action;
    private final CapabilityPattern actionPattern;

    public static TargetPlatformFilter removeAllFilter(CapabilityPattern scopePattern) {
        return new TargetPlatformFilter(scopePattern, FilterAction.REMOVE_ALL, null);
    }

    public static TargetPlatformFilter restrictionFilter(CapabilityPattern scopePattern, CapabilityPattern restrictionPattern) {
        return new TargetPlatformFilter(scopePattern, FilterAction.RESTRICT, restrictionPattern);
    }

    private TargetPlatformFilter(CapabilityPattern scopePattern, FilterAction action, CapabilityPattern actionPattern) {
        this.scopePattern = scopePattern;
        this.action = action;
        this.actionPattern = actionPattern;
    }

    public CapabilityPattern getScopePattern() {
        return this.scopePattern;
    }

    public FilterAction getAction() {
        return this.action;
    }

    public CapabilityPattern getActionPattern() {
        return this.actionPattern;
    }

    public String toString() {
        String commonPart = "TargetPlatformFilter(scope=" + this.scopePattern + ", action=" + (Object)((Object)this.action);
        switch (this.action) {
            case REMOVE_ALL: {
                return String.valueOf(commonPart) + ")";
            }
            case RESTRICT: {
                return String.valueOf(commonPart) + ", restriction=" + this.actionPattern + ")";
            }
        }
        return super.toString();
    }

    public static final class CapabilityPattern {
        private final CapabilityType type;
        private final String id;
        private final String version;
        private final String versionRange;

        public static CapabilityPattern patternWithVersion(CapabilityType type, String id, String version) {
            return new CapabilityPattern(type, id, version, null);
        }

        public static CapabilityPattern patternWithVersionRange(CapabilityType type, String id, String versionRange) {
            return new CapabilityPattern(type, id, null, versionRange);
        }

        public static CapabilityPattern patternWithoutVersion(CapabilityType type, String id) {
            return new CapabilityPattern(type, id, null, null);
        }

        private CapabilityPattern(CapabilityType type, String id, String version, String versionRange) {
            this.type = type;
            this.id = id;
            this.version = version;
            this.versionRange = versionRange;
        }

        public CapabilityType getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public String getVersionRange() {
            return this.versionRange;
        }

        public String toString() {
            StringBuilder result = new StringBuilder("CapabilityPattern(");
            this.printMembers(result);
            result.append(")");
            return result.toString();
        }

        private void printMembers(StringBuilder result) {
            int lengthWithoutMembers = result.length();
            if (this.type != null) {
                result.append("type=" + (Object)((Object)this.type) + ", ");
            }
            if (this.id != null) {
                result.append("id=\"" + this.id + "\", ");
            }
            if (this.version != null) {
                result.append("version=\"" + this.version + "\", ");
            }
            if (this.versionRange != null) {
                result.append("versionRange=\"" + this.versionRange + "\", ");
            }
            result.setLength(Math.max(lengthWithoutMembers, result.length() - 2));
        }

        public String printMembers() {
            StringBuilder result = new StringBuilder();
            this.printMembers(result);
            return result.toString();
        }

        public int hashCode() {
            int prime = 17;
            int result = 1;
            result = 17 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 17 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 17 * result + (this.version == null ? 0 : this.version.hashCode());
            result = 17 * result + (this.versionRange == null ? 0 : this.versionRange.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CapabilityPattern)) {
                return false;
            }
            CapabilityPattern other = (CapabilityPattern)obj;
            return CapabilityPattern.isEqual(this.type, other.type) && CapabilityPattern.isEqual(this.id, other.id) && CapabilityPattern.isEqual(this.version, other.version) && CapabilityPattern.isEqual(this.versionRange, other.versionRange);
        }

        private static <T> boolean isEqual(T left, T right) {
            if (left == right) {
                return true;
            }
            if (left == null) {
                return false;
            }
            return left.equals(right);
        }
    }

    public static enum CapabilityType {
        OSGI_BUNDLE,
        JAVA_PACKAGE,
        P2_INSTALLABLE_UNIT;


        public static CapabilityType parsePomValue(String typeString) {
            if (typeString.equals("eclipse-plugin") || typeString.equals("osgi-bundle")) {
                return OSGI_BUNDLE;
            }
            if (typeString.equals("p2-installable-unit")) {
                return P2_INSTALLABLE_UNIT;
            }
            if (typeString.equals("java-package")) {
                return JAVA_PACKAGE;
            }
            throw new IllegalArgumentException("Non-recognized capability type: " + typeString);
        }
    }

    public static enum FilterAction {
        REMOVE_ALL,
        RESTRICT;

    }
}

