/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver.shared;

import java.util.Properties;

public class PlatformPropertiesUtils {
    public static final String INTERNAL_ARCH_I386 = "i386";
    public static final String INTERNAL_AMD64 = "amd64";
    public static final String INTERNAL_OS_SUNOS = "SunOS";
    public static final String INTERNAL_OS_LINUX = "Linux";
    public static final String INTERNAL_OS_MACOSX = "Mac OS";
    public static final String INTERNAL_OS_AIX = "AIX";
    public static final String INTERNAL_OS_HPUX = "HP-UX";
    public static final String INTERNAL_OS_QNX = "QNX";
    public static final String INTERNAL_OS_FREEBSD = "FreeBSD";
    public static final String ARCH_X86 = "x86";
    public static final String ARCH_X86_64 = "x86_64";
    public static final String ARCH_PPC = "ppc";
    public static final String OSGI_WS = "osgi.ws";
    public static final String OSGI_OS = "osgi.os";
    public static final String OSGI_ARCH = "osgi.arch";
    public static final String OSGI_NL = "osgi.nl";
    public static final String OS_WIN32 = "win32";
    public static final String OS_LINUX = "linux";
    public static final String OS_AIX = "aix";
    public static final String OS_SOLARIS = "solaris";
    public static final String OS_HPUX = "hpux";
    public static final String OS_QNX = "qnx";
    public static final String OS_MACOSX = "macosx";
    public static final String OS_FREEBSD = "freebsd";
    public static final String OS_UNKNOWN = "unknown";
    public static final String WS_WIN32 = "win32";
    public static final String WS_WPF = "wpf";
    public static final String WS_MOTIF = "motif";
    public static final String WS_GTK = "gtk";
    public static final String WS_PHOTON = "photon";
    public static final String WS_CARBON = "carbon";
    public static final String WS_COCOA = "cocoa";
    public static final String WS_UNKNOWN = "unknown";

    public static String getWS(Properties properties) {
        String ws = properties.getProperty(OSGI_WS);
        if (ws != null) {
            return ws;
        }
        String osName = PlatformPropertiesUtils.getOS(properties);
        if (osName.equals("win32")) {
            return "win32";
        }
        if (osName.equals(OS_LINUX)) {
            return WS_GTK;
        }
        if (osName.equals(OS_FREEBSD)) {
            return WS_GTK;
        }
        if (osName.equals(OS_MACOSX)) {
            String arch = PlatformPropertiesUtils.getArch(properties);
            if (ARCH_X86_64.equals(arch)) {
                return WS_COCOA;
            }
            return WS_CARBON;
        }
        if (osName.equals(OS_HPUX)) {
            return WS_MOTIF;
        }
        if (osName.equals(OS_AIX)) {
            return WS_MOTIF;
        }
        if (osName.equals(OS_SOLARIS)) {
            return WS_GTK;
        }
        if (osName.equals(OS_QNX)) {
            return WS_PHOTON;
        }
        return "unknown";
    }

    public static String getOS(Properties properties) {
        String os = properties.getProperty(OSGI_OS);
        if (os != null) {
            return os;
        }
        String osName = System.getProperties().getProperty("os.name");
        if (osName.regionMatches(true, 0, "win32", 0, 3)) {
            return "win32";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_SUNOS)) {
            return OS_SOLARIS;
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_LINUX)) {
            return OS_LINUX;
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_QNX)) {
            return OS_QNX;
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_AIX)) {
            return OS_AIX;
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_HPUX)) {
            return OS_HPUX;
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_FREEBSD)) {
            return OS_FREEBSD;
        }
        if (osName.regionMatches(true, 0, INTERNAL_OS_MACOSX, 0, INTERNAL_OS_MACOSX.length())) {
            return OS_MACOSX;
        }
        return "unknown";
    }

    public static String getArch(Properties properties) {
        String arch = properties.getProperty(OSGI_ARCH);
        if (arch != null) {
            return arch;
        }
        String name = System.getProperties().getProperty("os.arch");
        if (name.equalsIgnoreCase(INTERNAL_ARCH_I386)) {
            return ARCH_X86;
        }
        if (name.equalsIgnoreCase(INTERNAL_AMD64)) {
            return ARCH_X86_64;
        }
        return name;
    }

    private static final class Constants
    extends PlatformPropertiesUtils {
        private Constants() {
        }
    }
}

