/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnTriggerableActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.SignalEventListener;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.SignalEventSubscriptionEntity;

public class SignalEventListenerActivityBehaviour
extends CoreCmmnTriggerableActivityBehavior
implements PlanItemActivityBehavior {
    protected String signalRef;

    public SignalEventListenerActivityBehaviour(SignalEventListener signalEventListener) {
        this.signalRef = signalEventListener.getSignalRef();
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        if ("terminate".equals(transition) || "exit".equals(transition) || "dismiss".equals(transition)) {
            EventSubscriptionService eventSubscriptionService = CommandContextUtil.getEventSubscriptionService(commandContext);
            List eventSubscriptions = eventSubscriptionService.findEventSubscriptionsBySubScopeId(planItemInstance.getId());
            for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                eventSubscriptionService.deleteEventSubscription(eventSubscription);
            }
        }
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        String signalName = null;
        if (StringUtils.isNotEmpty((CharSequence)this.signalRef)) {
            Expression signalExpression = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getExpressionManager().createExpression(this.signalRef);
            signalName = signalExpression.getValue((VariableContainer)planItemInstanceEntity).toString();
        }
        CommandContextUtil.getEventSubscriptionService(commandContext).createEventSubscriptionBuilder().eventType("signal").eventName(signalName).subScopeId(planItemInstanceEntity.getId()).scopeId(planItemInstanceEntity.getCaseInstanceId()).scopeDefinitionId(planItemInstanceEntity.getCaseDefinitionId()).scopeType("cmmn").tenantId(planItemInstanceEntity.getTenantId()).create();
    }

    @Override
    public void trigger(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        EventSubscriptionService eventSubscriptionService = CommandContextUtil.getEventSubscriptionService(commandContext);
        String signalName = null;
        if (StringUtils.isNotEmpty((CharSequence)this.signalRef)) {
            Expression signalExpression = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getExpressionManager().createExpression(this.signalRef);
            signalName = signalExpression.getValue((VariableContainer)planItemInstanceEntity).toString();
        }
        List eventSubscriptions = eventSubscriptionService.findEventSubscriptionsBySubScopeId(planItemInstanceEntity.getId());
        for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
            if (!(eventSubscription instanceof SignalEventSubscriptionEntity) || !eventSubscription.getEventName().equals(signalName)) continue;
            eventSubscriptionService.deleteEventSubscription(eventSubscription);
        }
        CommandContextUtil.getAgenda(commandContext).planOccurPlanItemInstanceOperation(planItemInstanceEntity);
    }
}

