/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.function;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.function.AbstractCmmnExpressionFunction;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.PlanItemInstanceContainerUtil;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.PlanItemDefinition;

public class IsStageCompletableExpressionFunction
extends AbstractCmmnExpressionFunction {
    public IsStageCompletableExpressionFunction() {
        super("isStageCompletable");
    }

    protected boolean isMultiParameterFunction() {
        return false;
    }

    protected boolean isNoParameterMethod() {
        return true;
    }

    public static boolean isStageCompletable(Object object) {
        if (object instanceof PlanItemInstanceEntity) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)object;
            if (planItemInstanceEntity.isStage()) {
                return planItemInstanceEntity.isCompleteable();
            }
            if (planItemInstanceEntity.getStageInstanceId() != null) {
                PlanItemInstanceEntity stagePlanItemInstanceEntity = planItemInstanceEntity.getStagePlanItemInstanceEntity();
                PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItem().getPlanItemDefinition();
                if ("available".equals(planItemInstanceEntity.getState()) && planItemDefinition instanceof EventListener && StringUtils.isNotEmpty((CharSequence)((EventListener)planItemDefinition).getAvailableConditionExpression())) {
                    return PlanItemInstanceContainerUtil.isEndStateReachedForAllRequiredChildPlanItems(stagePlanItemInstanceEntity, Collections.singletonList(planItemInstanceEntity.getId()));
                }
                return stagePlanItemInstanceEntity.isCompleteable();
            }
            CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager().findById(planItemInstanceEntity.getCaseInstanceId());
            return caseInstanceEntity.isCompleteable();
        }
        if (object instanceof CaseInstanceEntity) {
            CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)object;
            return caseInstanceEntity.isCompleteable();
        }
        return false;
    }
}

