/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.listener;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.listener.CaseInstanceLifecycleListener;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.impl.deployer.CmmnDeploymentManager;
import org.flowable.cmmn.engine.impl.listener.CmmnListenerNotificationHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.FlowableListener;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class CaseLifeCycleListenerUtil {
    public static void callLifecycleListeners(CommandContext commandContext, CaseInstance caseInstance, String oldState, String newState) {
        if (Objects.equals(oldState, newState)) {
            return;
        }
        Case caseModel = CaseLifeCycleListenerUtil.getCaseModel(caseInstance.getCaseDefinitionId());
        List flowableListeners = caseModel.getLifecycleListeners();
        if (flowableListeners != null && !flowableListeners.isEmpty()) {
            CmmnListenerNotificationHelper listenerNotificationHelper = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getListenerNotificationHelper();
            for (FlowableListener flowableListener : flowableListeners) {
                if (!CaseLifeCycleListenerUtil.stateMatches(flowableListener.getSourceState(), oldState) || !CaseLifeCycleListenerUtil.stateMatches(flowableListener.getTargetState(), newState)) continue;
                CaseInstanceLifecycleListener lifecycleListener = listenerNotificationHelper.createCaseLifecycleListener(flowableListener);
                CaseLifeCycleListenerUtil.executeLifecycleListener(caseInstance, oldState, newState, lifecycleListener);
            }
        }
    }

    protected static void executeLifecycleListener(CaseInstance caseInstance, String oldState, String newState, CaseInstanceLifecycleListener lifecycleListener) {
        if (CaseLifeCycleListenerUtil.lifecycleListenerMatches(lifecycleListener, oldState, newState)) {
            lifecycleListener.stateChanged(caseInstance, oldState, newState);
        }
    }

    protected static boolean lifecycleListenerMatches(CaseInstanceLifecycleListener lifecycleListener, String oldState, String newState) {
        return CaseLifeCycleListenerUtil.stateMatches(lifecycleListener.getSourceState(), oldState) && CaseLifeCycleListenerUtil.stateMatches(lifecycleListener.getTargetState(), newState);
    }

    protected static boolean stateMatches(String listenerExpectedState, String actualState) {
        return StringUtils.isEmpty((CharSequence)listenerExpectedState) || Objects.equals(actualState, listenerExpectedState);
    }

    protected static Case getCaseModel(String caseDefinitionId) {
        CmmnDeploymentManager deploymentManager = CommandContextUtil.getCmmnEngineConfiguration().getDeploymentManager();
        CaseDefinition caseDefinitionEntity = deploymentManager.findDeployedCaseDefinitionById(caseDefinitionId);
        CmmnModel cmmnModel = deploymentManager.resolveCaseDefinition(caseDefinitionEntity).getCmmnModel();
        return cmmnModel.getCaseById(caseDefinitionEntity.getKey());
    }
}

