/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.ArrayList;
import java.util.List;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableOptimisticLockingException;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AsyncRunnableExecutionExceptionHandler;
import org.flowable.job.service.impl.cmd.ExecuteAsyncJobCmd;
import org.flowable.job.service.impl.cmd.LockExclusiveJobCmd;
import org.flowable.job.service.impl.cmd.UnlockExclusiveJobCmd;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;
import org.flowable.job.service.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteAsyncRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteAsyncRunnable.class);
    protected String jobId;
    protected JobInfo job;
    protected JobServiceConfiguration jobServiceConfiguration;
    protected JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;
    protected List<AsyncRunnableExecutionExceptionHandler> asyncRunnableExecutionExceptionHandlers;

    public ExecuteAsyncRunnable(String jobId, JobServiceConfiguration jobServiceConfiguration, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager, AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler) {
        this.initialize(jobId, null, jobServiceConfiguration, jobEntityManager, asyncRunnableExecutionExceptionHandler);
    }

    public ExecuteAsyncRunnable(JobInfo job, JobServiceConfiguration jobServiceConfiguration, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager, AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler) {
        this.initialize(job.getId(), job, jobServiceConfiguration, jobEntityManager, asyncRunnableExecutionExceptionHandler);
    }

    private void initialize(String jobId, JobInfo job, JobServiceConfiguration jobServiceConfiguration, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager, AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler) {
        this.job = job;
        this.jobId = jobId;
        this.jobServiceConfiguration = jobServiceConfiguration;
        this.jobEntityManager = jobEntityManager;
        this.asyncRunnableExecutionExceptionHandlers = this.initializeExceptionHandlers(jobServiceConfiguration, asyncRunnableExecutionExceptionHandler);
    }

    private List<AsyncRunnableExecutionExceptionHandler> initializeExceptionHandlers(JobServiceConfiguration jobServiceConfiguration, AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler) {
        ArrayList<AsyncRunnableExecutionExceptionHandler> asyncRunnableExecutionExceptionHandlers = new ArrayList<AsyncRunnableExecutionExceptionHandler>();
        if (asyncRunnableExecutionExceptionHandler != null) {
            asyncRunnableExecutionExceptionHandlers.add(asyncRunnableExecutionExceptionHandler);
        }
        if (jobServiceConfiguration.getAsyncRunnableExecutionExceptionHandlers() != null) {
            asyncRunnableExecutionExceptionHandlers.addAll(jobServiceConfiguration.getAsyncRunnableExecutionExceptionHandlers());
        }
        return asyncRunnableExecutionExceptionHandlers;
    }

    @Override
    public void run() {
        if (this.job == null) {
            this.job = (JobInfo)this.jobServiceConfiguration.getCommandExecutor().execute((Command)new Command<JobInfoEntity>(){

                public JobInfoEntity execute(CommandContext commandContext) {
                    return (JobInfoEntity)ExecuteAsyncRunnable.this.jobEntityManager.findById(ExecuteAsyncRunnable.this.jobId);
                }
            });
        }
        if (this.job instanceof Job) {
            Job jobObject = (Job)this.job;
            if (this.jobServiceConfiguration.getInternalJobManager() != null && this.jobServiceConfiguration.getInternalJobManager().isFlowable5ProcessDefinitionId(jobObject.getProcessDefinitionId())) {
                this.jobServiceConfiguration.getInternalJobManager().executeV5JobWithLockAndRetry(jobObject);
                return;
            }
        }
        if (this.job instanceof AbstractRuntimeJobEntity) {
            boolean lockNotNeededOrSuccess = this.lockJobIfNeeded();
            if (lockNotNeededOrSuccess) {
                this.executeJob();
                this.unlockJobIfNeeded();
            }
        } else {
            this.executeJob();
        }
    }

    protected void executeJob() {
        try {
            this.jobServiceConfiguration.getCommandExecutor().execute((Command)new ExecuteAsyncJobCmd(this.jobId, this.jobEntityManager));
        }
        catch (FlowableOptimisticLockingException e) {
            this.handleFailedJob(e);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Optimistic locking exception during job execution. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire an exclusive job, which already was changed by another async executor thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor threads running against the same database. Exception message: {}", (Object)e.getMessage());
            }
        }
        catch (Throwable exception) {
            this.handleFailedJob(exception);
        }
    }

    protected void unlockJobIfNeeded() {
        Job job = (Job)this.job;
        try {
            if (job.isExclusive()) {
                this.jobServiceConfiguration.getCommandExecutor().execute((Command)new UnlockExclusiveJobCmd(job));
            }
        }
        catch (FlowableOptimisticLockingException optimisticLockingException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Optimistic locking exception while unlocking the job. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire an exclusive job, which already was changed by another async executor thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor acquisition threads running against the same database. Exception message: {}", (Object)optimisticLockingException.getMessage());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error while unlocking exclusive job {}", (Object)job.getId(), (Object)t);
        }
    }

    protected boolean lockJobIfNeeded() {
        Job job = (Job)this.job;
        try {
            if (job.isExclusive()) {
                this.jobServiceConfiguration.getCommandExecutor().execute((Command)new LockExclusiveJobCmd(job));
            }
        }
        catch (Throwable lockException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Could not lock exclusive job. Unlocking job so it can be acquired again. Caught exception: {}", (Object)lockException.getMessage());
            }
            this.unacquireJob();
            return false;
        }
        return true;
    }

    protected void unacquireJob() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            CommandContextUtil.getJobManager(commandContext).unacquire(this.job);
        } else {
            this.jobServiceConfiguration.getCommandExecutor().execute((Command)new Command<Void>(){

                public Void execute(CommandContext commandContext) {
                    CommandContextUtil.getJobManager(commandContext).unacquire(ExecuteAsyncRunnable.this.job);
                    return null;
                }
            });
        }
    }

    protected void handleFailedJob(Throwable exception) {
        for (AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler : this.asyncRunnableExecutionExceptionHandlers) {
            if (!asyncRunnableExecutionExceptionHandler.handleException(this.jobServiceConfiguration, this.job, exception)) continue;
            return;
        }
        LOGGER.error("Unable to handle exception {} for job {}.", (Object)exception, (Object)this.job);
        throw new FlowableException("Unable to handle exception " + exception.getMessage() + " for job " + this.job.getId() + ".", exception);
    }
}

