/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import org.flowable.app.engine.AppEngine;
import org.flowable.engine.DynamicBpmnService;
import org.flowable.engine.FormService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngines;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.spring.ProcessEngineFactoryBean;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.BaseEngineConfigurationWithConfigurers;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineServicesAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnProcessEngine;
import org.flowable.spring.boot.process.FlowableProcessProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProcessEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableProcessProperties.class})
@AutoConfigureAfter(value={ProcessEngineAutoConfiguration.class, AppEngineServicesAutoConfiguration.class})
public class ProcessEngineServicesAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RuntimeService runtimeServiceBean(ProcessEngine processEngine) {
        return processEngine.getRuntimeService();
    }

    @Bean
    @ConditionalOnMissingBean
    public RepositoryService repositoryServiceBean(ProcessEngine processEngine) {
        return processEngine.getRepositoryService();
    }

    @Bean
    @ConditionalOnMissingBean
    public TaskService taskServiceBean(ProcessEngine processEngine) {
        return processEngine.getTaskService();
    }

    @Bean
    @ConditionalOnMissingBean
    public HistoryService historyServiceBean(ProcessEngine processEngine) {
        return processEngine.getHistoryService();
    }

    @Bean
    @ConditionalOnMissingBean
    public ManagementService managementServiceBean(ProcessEngine processEngine) {
        return processEngine.getManagementService();
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicBpmnService dynamicBpmnServiceBean(ProcessEngine processEngine) {
        return processEngine.getDynamicBpmnService();
    }

    @Bean
    @ConditionalOnMissingBean
    public FormService formServiceBean(ProcessEngine processEngine) {
        return processEngine.getFormService();
    }

    @Bean
    @ConditionalOnMissingBean
    public IdentityService identityServiceBean(ProcessEngine processEngine) {
        return processEngine.getIdentityService();
    }

    @Configuration
    @ConditionalOnMissingBean(type={"org.flowable.engine.ProcessEngine", "org.flowable.app.engine.AppEngine"})
    static class StandaloneEngineConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringProcessEngineConfiguration> {
        StandaloneEngineConfiguration() {
        }

        @Bean
        public ProcessEngineFactoryBean processEngine(SpringProcessEngineConfiguration configuration) throws Exception {
            ProcessEngineFactoryBean processEngineFactoryBean = new ProcessEngineFactoryBean();
            processEngineFactoryBean.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)configuration);
            this.invokeConfigurers(configuration);
            return processEngineFactoryBean;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(type={"org.flowable.engine.ProcessEngine"})
    @ConditionalOnBean(type={"org.flowable.app.engine.AppEngine"})
    static class AlreadyInitializedAppEngineConfiguration {
        AlreadyInitializedAppEngineConfiguration() {
        }

        @Bean
        public ProcessEngine processEngine(@Autowired AppEngine appEngine) {
            if (!ProcessEngines.isInitialized()) {
                throw new IllegalStateException("BPMN engine has not been initialized");
            }
            return ProcessEngines.getDefaultProcessEngine();
        }
    }
}

