/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.cascading;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.validator.internal.engine.valueextraction.AnnotatedObject;
import org.hibernate.validator.internal.engine.valueextraction.ArrayElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.StringHelper;
import org.hibernate.validator.internal.util.TypeVariableBindings;
import org.hibernate.validator.internal.util.TypeVariables;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class CascadingTypeParameter {
    private static final Log LOG = LoggerFactory.make();
    private static final CascadingTypeParameter NON_CASCADING = new CascadingTypeParameter(null, null, null, null, false, Collections.emptyMap(), Collections.emptyMap());
    private final Type enclosingType;
    private final TypeVariable<?> typeParameter;
    private final Class<?> declaredContainerClass;
    private final TypeVariable<?> declaredTypeParameter;
    private final Map<TypeVariable<?>, CascadingTypeParameter> containerElementTypesCascadingMetaData;
    private final boolean cascading;
    private final Map<Class<?>, Class<?>> groupConversions;
    private final boolean markedForCascadingOnElementOrContainerElements;
    private final boolean hasGroupConversionsOnElementOrContainerElements;

    public CascadingTypeParameter(Type enclosingType, TypeVariable<?> typeParameter, boolean cascading, Map<TypeVariable<?>, CascadingTypeParameter> containerElementTypesCascadingMetaData, Map<Class<?>, Class<?>> groupConversions) {
        this(enclosingType, typeParameter, TypeVariables.getContainerClass(typeParameter), TypeVariables.getActualTypeParameter(typeParameter), cascading, containerElementTypesCascadingMetaData, groupConversions);
    }

    private CascadingTypeParameter(Type enclosingType, TypeVariable<?> typeParameter, Class<?> declaredContainerClass, TypeVariable<?> declaredTypeParameter, boolean cascading, Map<TypeVariable<?>, CascadingTypeParameter> containerElementTypesCascadingMetaData, Map<Class<?>, Class<?>> groupConversions) {
        this.enclosingType = enclosingType;
        this.typeParameter = typeParameter;
        this.declaredContainerClass = declaredContainerClass;
        this.declaredTypeParameter = declaredTypeParameter;
        this.cascading = cascading;
        this.groupConversions = CollectionHelper.toImmutableMap(groupConversions);
        this.containerElementTypesCascadingMetaData = CollectionHelper.toImmutableMap(containerElementTypesCascadingMetaData);
        boolean tmpMarkedForCascadingOnElementOrContainerElements = cascading;
        boolean tmpHasGroupConversionsOnElementOrContainerElements = !groupConversions.isEmpty();
        for (CascadingTypeParameter nestedCascadingTypeParameter : containerElementTypesCascadingMetaData.values()) {
            tmpMarkedForCascadingOnElementOrContainerElements = tmpMarkedForCascadingOnElementOrContainerElements || nestedCascadingTypeParameter.markedForCascadingOnElementOrContainerElements;
            tmpHasGroupConversionsOnElementOrContainerElements = tmpHasGroupConversionsOnElementOrContainerElements || nestedCascadingTypeParameter.hasGroupConversionsOnElementOrContainerElements;
        }
        this.markedForCascadingOnElementOrContainerElements = tmpMarkedForCascadingOnElementOrContainerElements;
        this.hasGroupConversionsOnElementOrContainerElements = tmpHasGroupConversionsOnElementOrContainerElements;
    }

    public static CascadingTypeParameter nonCascading() {
        return NON_CASCADING;
    }

    public static CascadingTypeParameter annotatedObject(Type cascadableType, boolean cascading, Map<TypeVariable<?>, CascadingTypeParameter> containerElementTypesCascadingMetaData, Map<Class<?>, Class<?>> groupConversions) {
        Map<TypeVariable<?>, CascadingTypeParameter> amendedContainerElementsCascadingMetaData = cascading ? CascadingTypeParameter.addPotentialLegacyCascadingMetaData(cascadableType, containerElementTypesCascadingMetaData, groupConversions) : containerElementTypesCascadingMetaData;
        return new CascadingTypeParameter(cascadableType, AnnotatedObject.INSTANCE, cascading, amendedContainerElementsCascadingMetaData, groupConversions);
    }

    public static CascadingTypeParameter arrayElement(Type cascadableType, boolean cascading, Map<TypeVariable<?>, CascadingTypeParameter> containerElementTypesCascadingMetaData, Map<Class<?>, Class<?>> groupConversions) {
        return new CascadingTypeParameter(cascadableType, new ArrayElement(cascadableType), cascading, containerElementTypesCascadingMetaData, groupConversions);
    }

    public TypeVariable<?> getTypeParameter() {
        return this.typeParameter;
    }

    public Type getEnclosingType() {
        return this.enclosingType;
    }

    public Class<?> getDeclaredContainerClass() {
        return this.declaredContainerClass;
    }

    public TypeVariable<?> getDeclaredTypeParameter() {
        return this.declaredTypeParameter;
    }

    public boolean isCascading() {
        return this.cascading;
    }

    public Map<Class<?>, Class<?>> getGroupConversions() {
        return this.groupConversions;
    }

    public boolean isMarkedForCascadingOnElementOrContainerElements() {
        return this.markedForCascadingOnElementOrContainerElements;
    }

    public boolean hasGroupConversionsOnElementOrContainerElements() {
        return this.hasGroupConversionsOnElementOrContainerElements;
    }

    public Map<TypeVariable<?>, CascadingTypeParameter> getContainerElementTypesCascadingMetaData() {
        return this.containerElementTypesCascadingMetaData;
    }

    public CascadingTypeParameter merge(CascadingTypeParameter otherCascadingTypeParameter) {
        if (this == NON_CASCADING) {
            return otherCascadingTypeParameter;
        }
        if (otherCascadingTypeParameter == NON_CASCADING) {
            return this;
        }
        boolean cascading = this.cascading || otherCascadingTypeParameter.cascading;
        Map<Class<?>, Class<?>> groupConversions = CascadingTypeParameter.mergeGroupConversion(this.groupConversions, otherCascadingTypeParameter.groupConversions);
        Map<TypeVariable<?>, CascadingTypeParameter> nestedCascadingTypeParameterMap = Stream.concat(this.containerElementTypesCascadingMetaData.entrySet().stream(), otherCascadingTypeParameter.containerElementTypesCascadingMetaData.entrySet().stream()).collect(Collectors.toMap(entry -> (TypeVariable)entry.getKey(), entry -> (CascadingTypeParameter)entry.getValue(), (value1, value2) -> value1.merge((CascadingTypeParameter)value2)));
        return new CascadingTypeParameter(this.enclosingType, this.typeParameter, cascading, nestedCascadingTypeParameterMap, groupConversions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append("enclosingType=").append(StringHelper.toShortString(this.enclosingType)).append(", ");
        sb.append("typeParameter=").append(this.typeParameter).append(", ");
        sb.append("cascading=").append(this.cascading).append(", ");
        sb.append("groupConversions=").append(this.groupConversions).append(", ");
        sb.append("containerElementTypesCascadingMetaData=").append(this.containerElementTypesCascadingMetaData);
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.typeParameter.hashCode();
        result = 31 * result + (this.cascading ? 1 : 0);
        result = 31 * result + this.groupConversions.hashCode();
        result = 31 * result + this.containerElementTypesCascadingMetaData.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CascadingTypeParameter other = (CascadingTypeParameter)obj;
        if (!this.typeParameter.equals(other.typeParameter)) {
            return false;
        }
        if (this.cascading != other.cascading) {
            return false;
        }
        if (!this.groupConversions.equals(other.groupConversions)) {
            return false;
        }
        return this.containerElementTypesCascadingMetaData.equals(other.containerElementTypesCascadingMetaData);
    }

    private static Map<Class<?>, Class<?>> mergeGroupConversion(Map<Class<?>, Class<?>> groupConversions, Map<Class<?>, Class<?>> otherGroupConversions) {
        if (groupConversions.isEmpty() && otherGroupConversions.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap mergedGroupConversions = new HashMap(groupConversions.size() + otherGroupConversions.size());
        for (Map.Entry<Class<?>, Class<?>> otherGroupConversionEntry : otherGroupConversions.entrySet()) {
            if (!groupConversions.containsKey(otherGroupConversionEntry.getKey())) continue;
            throw LOG.getMultipleGroupConversionsForSameSourceException(otherGroupConversionEntry.getKey(), CollectionHelper.asSet(groupConversions.get(otherGroupConversionEntry.getKey()), otherGroupConversionEntry.getValue()));
        }
        mergedGroupConversions.putAll(groupConversions);
        mergedGroupConversions.putAll(otherGroupConversions);
        return mergedGroupConversions;
    }

    private static Map<TypeVariable<?>, CascadingTypeParameter> addPotentialLegacyCascadingMetaData(Type cascadableType, Map<TypeVariable<?>, CascadingTypeParameter> containerElementTypesCascadingMetaData, Map<Class<?>, Class<?>> groupConversions) {
        Class<?> cascadableClass = ReflectionHelper.getClassFromType(cascadableType);
        if (Map.class.isAssignableFrom(cascadableClass)) {
            return CascadingTypeParameter.addLegacyCascadingMetaData(cascadableClass, Map.class, 1, containerElementTypesCascadingMetaData, groupConversions);
        }
        if (List.class.isAssignableFrom(cascadableClass)) {
            return CascadingTypeParameter.addLegacyCascadingMetaData(cascadableClass, List.class, 0, containerElementTypesCascadingMetaData, groupConversions);
        }
        if (Iterable.class.isAssignableFrom(cascadableClass)) {
            return CascadingTypeParameter.addLegacyCascadingMetaData(cascadableClass, Iterable.class, 0, containerElementTypesCascadingMetaData, groupConversions);
        }
        if (Optional.class.isAssignableFrom(cascadableClass)) {
            return CascadingTypeParameter.addLegacyCascadingMetaData(cascadableClass, Optional.class, 0, containerElementTypesCascadingMetaData, groupConversions);
        }
        if (cascadableClass.isArray()) {
            return CascadingTypeParameter.addArrayElementCascadingMetaData(cascadableClass, containerElementTypesCascadingMetaData, groupConversions);
        }
        return containerElementTypesCascadingMetaData;
    }

    private static Map<TypeVariable<?>, CascadingTypeParameter> addLegacyCascadingMetaData(Class<?> enclosingType, Class<?> referenceType, int typeParameterIndex, Map<TypeVariable<?>, CascadingTypeParameter> containerElementTypesCascadingMetaData, Map<Class<?>, Class<?>> groupConversions) {
        TypeVariable<Class<?>> cascadableTypeParameter;
        Class<?> cascadableClass;
        Map<Class<?>, Map<TypeVariable<?>, TypeVariable<?>>> typeVariableBindings = TypeVariableBindings.getTypeVariableBindings(enclosingType);
        TypeVariable<Class<?>> correspondingTypeParameter = typeVariableBindings.get(referenceType).entrySet().stream().filter(e -> Objects.equals(((TypeVariable)e.getKey()).getGenericDeclaration(), enclosingType)).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)).get(referenceType.getTypeParameters()[typeParameterIndex]);
        if (correspondingTypeParameter != null) {
            cascadableClass = enclosingType;
            cascadableTypeParameter = correspondingTypeParameter;
        } else {
            cascadableClass = referenceType;
            cascadableTypeParameter = referenceType.getTypeParameters()[typeParameterIndex];
        }
        HashMap<TypeVariable<?>, CascadingTypeParameter> amendedCascadingMetadata = CollectionHelper.newHashMap(containerElementTypesCascadingMetaData.size() + 1);
        amendedCascadingMetadata.putAll(containerElementTypesCascadingMetaData);
        if (containerElementTypesCascadingMetaData.containsKey(cascadableTypeParameter)) {
            amendedCascadingMetadata.put(cascadableTypeParameter, CascadingTypeParameter.makeCascading(containerElementTypesCascadingMetaData.get(cascadableTypeParameter), groupConversions));
        } else {
            amendedCascadingMetadata.put(cascadableTypeParameter, new CascadingTypeParameter(cascadableClass, cascadableTypeParameter, enclosingType, correspondingTypeParameter, true, Collections.emptyMap(), groupConversions));
        }
        return amendedCascadingMetadata;
    }

    private static Map<TypeVariable<?>, CascadingTypeParameter> addArrayElementCascadingMetaData(Class<?> enclosingType, Map<TypeVariable<?>, CascadingTypeParameter> containerElementTypesCascadingMetaData, Map<Class<?>, Class<?>> groupConversions) {
        HashMap<TypeVariable<?>, CascadingTypeParameter> amendedCascadingMetadata = CollectionHelper.newHashMap(containerElementTypesCascadingMetaData.size() + 1);
        amendedCascadingMetadata.putAll(containerElementTypesCascadingMetaData);
        ArrayElement cascadableTypeParameter = new ArrayElement(enclosingType);
        amendedCascadingMetadata.put(cascadableTypeParameter, new CascadingTypeParameter(enclosingType, cascadableTypeParameter, true, Collections.emptyMap(), groupConversions));
        return amendedCascadingMetadata;
    }

    private static CascadingTypeParameter makeCascading(CascadingTypeParameter cascadingTypeParameter, Map<Class<?>, Class<?>> groupConversions) {
        return new CascadingTypeParameter(cascadingTypeParameter.enclosingType, cascadingTypeParameter.typeParameter, true, cascadingTypeParameter.containerElementTypesCascadingMetaData, cascadingTypeParameter.groupConversions.isEmpty() ? groupConversions : cascadingTypeParameter.groupConversions);
    }
}

