/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.jdkspecific;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.stream.Stream;

public class ProcessorInfo {
    private static final byte[] BITS = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    private static final String CPUS_ALLOWED = "Cpus_allowed:";
    private static final String CGROUP_STATUS_FILE = "/proc/cgroups";
    private static final String CPU_CFS_PERIOD_US = "/sys/fs/cgroup/cpu/cpu.cfs_period_us";
    private static final String CPU_CFS_QUOTA_US = "/sys/fs/cgroup/cpu/cpu.cfs_quota_us";
    private static final String CPU_SHARES = "/sys/fs/cgroup/cpu/cpu.shares";
    private static final String PROC_SELF_STATUS = "/proc/self/status";

    private ProcessorInfo() {
    }

    public static int availableProcessors() {
        long cpuQuota;
        int cpuShares;
        int javaProcs = Runtime.getRuntime().availableProcessors();
        int userProcs = Integer.getInteger("infinispan.activeprocessorcount", javaProcs);
        if (!ProcessorInfo.isLinux()) {
            return Math.min(userProcs, javaProcs);
        }
        int maskProcs = ProcessorInfo.readCPUMask();
        if (maskProcs < 0) {
            maskProcs = userProcs;
        }
        if ((cpuShares = ProcessorInfo.readCPUShares()) == 1024) {
            cpuShares = userProcs;
        }
        double cpuRatio = (cpuQuota = ProcessorInfo.readCPUCFSQuotaUS()) < 0L ? (double)userProcs : Math.ceil((float)cpuQuota / (float)ProcessorInfo.readCPUCFSPeriodUS());
        return Math.min(userProcs, Math.min(maskProcs, Math.min(cpuShares, (int)cpuRatio)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int readCPUMask() {
        try (Stream<String> lines = Files.lines(Paths.get(PROC_SELF_STATUS, new String[0]), StandardCharsets.US_ASCII);){
            int n = lines.filter(line -> line.startsWith(CPUS_ALLOWED)).findFirst().map(line -> {
                int start;
                int count = 0;
                for (int i = start = CPUS_ALLOWED.length(); i < line.length(); ++i) {
                    char ch = line.charAt(i);
                    if (ch >= '0' && ch <= '9') {
                        count += BITS[ch - 48];
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'f') {
                        count += BITS[ch - 97 + 10];
                        continue;
                    }
                    if (ch < 'A' || ch > 'F') continue;
                    count += BITS[ch - 65 + 10];
                }
                return count;
            }).orElse(-1);
            return n;
        }
        catch (IOException e) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long readCPUCFSQuotaUS() {
        if (!ProcessorInfo.hasCGroups()) {
            return -1L;
        }
        try (Stream<String> lines = Files.lines(Paths.get(CPU_CFS_QUOTA_US, new String[0]), StandardCharsets.US_ASCII);){
            long l = lines.findFirst().map(line -> Long.parseLong(line)).orElse(-1L);
            return l;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long readCPUCFSPeriodUS() {
        try (Stream<String> lines = Files.lines(Paths.get(CPU_CFS_PERIOD_US, new String[0]), StandardCharsets.US_ASCII);){
            long l = lines.findFirst().map(line -> Long.parseLong(line)).orElse(100000L);
            return l;
        }
        catch (IOException e) {
            return 100000L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int readCPUShares() {
        try (Stream<String> lines = Files.lines(Paths.get(CPU_SHARES, new String[0]), StandardCharsets.US_ASCII);){
            int n = lines.findFirst().map(line -> Integer.parseInt(line)).orElse(1024);
            return n;
        }
        catch (IOException e) {
            return 1024;
        }
    }

    private static boolean isLinux() {
        String osArch = System.getProperty("os.name", "unknown").toLowerCase(Locale.US);
        return osArch.contains("linux");
    }

    private static boolean hasCGroups() {
        return Files.exists(Paths.get(CGROUP_STATUS_FILE, new String[0]), new LinkOption[0]);
    }
}

