/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.jdeparser.AbstractJType;
import org.jboss.jdeparser.AnnotationJClassDef;
import org.jboss.jdeparser.BasicJCommentable;
import org.jboss.jdeparser.BlankLine;
import org.jboss.jdeparser.ClassFileContent;
import org.jboss.jdeparser.EnumJClassDef;
import org.jboss.jdeparser.ImplJSources;
import org.jboss.jdeparser.InterfaceJClassDef;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JSourceFile;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.NestedJType;
import org.jboss.jdeparser.PlainJClassDef;
import org.jboss.jdeparser.ReferenceJType;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.StaticRefJExpr;
import org.jboss.jdeparser.Tokens$;

class ImplJSourceFile
extends BasicJCommentable
implements JSourceFile {
    private final ImplJSources sources;
    private final Map<String, AbstractJType> imports = new HashMap<String, AbstractJType>();
    private final Map<String, StaticRefJExpr> staticImports = new HashMap<String, StaticRefJExpr>();
    private final ArrayList<ClassFileContent> content = new ArrayList();
    private final String packageName;
    private final String fileName;
    private boolean packageWritten;

    ImplJSourceFile(ImplJSources sources, String packageName, String fileName) {
        this.sources = sources;
        this.packageName = packageName;
        this.fileName = fileName;
    }

    private <C extends ClassFileContent> C add(C item) {
        this.content.add(item);
        return item;
    }

    private void checkPackage() {
        if (!this.packageWritten) {
            this.content.add(new ClassFileContent(){

                @Override
                public void write(SourceFileWriter writer) throws IOException {
                    Map staticImports;
                    Iterator staticIterator;
                    writer.write(Tokens$.KW.PACKAGE);
                    writer.sp();
                    writer.writeEscaped(ImplJSourceFile.this.packageName);
                    writer.write(Tokens$.PUNCT.SEMI);
                    writer.nl();
                    Map imports = ImplJSourceFile.this.imports;
                    Iterator iterator = imports.values().iterator();
                    if (iterator.hasNext()) {
                        writer.nl();
                        do {
                            AbstractJType _import = (AbstractJType)iterator.next();
                            writer.write(Tokens$.KW.IMPORT);
                            writer.writeClass(_import.qualifiedName());
                            writer.write(Tokens$.PUNCT.SEMI);
                            writer.nl();
                        } while (iterator.hasNext());
                        writer.nl();
                    }
                    if ((staticIterator = (staticImports = ImplJSourceFile.this.staticImports).values().iterator()).hasNext()) {
                        writer.nl();
                        do {
                            StaticRefJExpr staticImport = (StaticRefJExpr)staticIterator.next();
                            writer.write(Tokens$.KW.IMPORT);
                            writer.write(Tokens$.KW.STATIC);
                            staticImport.writeForImport(writer);
                            writer.write(Tokens$.PUNCT.SEMI);
                            writer.nl();
                        } while (staticIterator.hasNext());
                        writer.nl();
                    }
                }
            });
            this.packageWritten = true;
        }
    }

    boolean hasImport(String name) {
        return this.imports.containsKey(name);
    }

    boolean hasImport(AbstractJType type) {
        return type.equals(this.imports.get(type.simpleName()));
    }

    boolean hasStaticImport(String name) {
        return this.staticImports.containsKey(name);
    }

    boolean hasStaticImport(String name, AbstractJType enclosingType) {
        StaticRefJExpr expr = this.staticImports.get(name);
        return expr != null && enclosingType.equals(expr.getType());
    }

    @Override
    public JSourceFile _import(String type) {
        return this._import(JTypes.typeNamed(type));
    }

    @Override
    public JSourceFile _import(JType type) {
        if (!(type instanceof ReferenceJType) && !(type instanceof NestedJType)) {
            return this;
        }
        if (this.imports.containsKey(type.simpleName())) {
            return this;
        }
        this.checkPackage();
        this.imports.put(type.simpleName(), (AbstractJType)type);
        return this;
    }

    @Override
    public JSourceFile _import(Class<?> type) {
        return this._import(JTypes.typeOf(type));
    }

    @Override
    public JSourceFile importStatic(String type, String member) {
        return this.importStatic(JTypes.typeNamed(type), member);
    }

    @Override
    public JSourceFile importStatic(JType type, String member) {
        if (!(type instanceof ReferenceJType) && !(type instanceof NestedJType)) {
            return this;
        }
        if (this.staticImports.containsKey(member)) {
            return this;
        }
        this.checkPackage();
        this.staticImports.put(member, new StaticRefJExpr(AbstractJType.of(type), member));
        return this;
    }

    @Override
    public JSourceFile importStatic(Class<?> type, String member) {
        return this.importStatic(JTypes.typeOf(type), member);
    }

    @Override
    public JSourceFile blankLine() {
        this.checkPackage();
        this.add(BlankLine.getInstance());
        return this;
    }

    @Override
    public JClassDef _class(int mods, String name) {
        this.checkPackage();
        return this.add(new PlainJClassDef(mods, this, name));
    }

    @Override
    public JClassDef _enum(int mods, String name) {
        this.checkPackage();
        return this.add(new EnumJClassDef(mods, this, name));
    }

    @Override
    public JClassDef _interface(int mods, String name) {
        this.checkPackage();
        return this.add(new InterfaceJClassDef(mods, this, name));
    }

    @Override
    public JClassDef annotationInterface(int mods, String name) {
        this.checkPackage();
        return this.add(new AnnotationJClassDef(mods, this, name));
    }

    String getPackageName() {
        return this.packageName;
    }

    String getFileName() {
        return this.fileName;
    }

    void write(SourceFileWriter sourceFileWriter) throws IOException {
        sourceFileWriter.setClassFile(this);
        for (ClassFileContent item : this.content) {
            item.write(sourceFileWriter);
        }
        sourceFileWriter.setClassFile(null);
    }

    ImplJSources getSources() {
        return this.sources;
    }
}

