/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.from;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.TableFunction;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.reactor.ql.ReactorQLContext;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.FromFeature;
import reactor.core.publisher.Flux;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class ZipSelectFeature
implements FromFeature {
    private static final String ID = FeatureId.From.of("zip").getId();

    @Override
    public Function<ReactorQLContext, Flux<ReactorQLRecord>> createFromMapper(FromItem fromItem, ReactorQLMetadata metadata) {
        List from;
        TableFunction table = (TableFunction)fromItem;
        net.sf.jsqlparser.expression.Function function = table.getFunction();
        if (function.getParameters() == null || CollectionUtils.isEmpty((Collection)(from = function.getParameters().getExpressions()))) {
            throw new UnsupportedOperationException("\u51fd\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String alias = table.getAlias() == null ? null : table.getAlias().getName();
        LinkedHashMap<String, Function<ReactorQLContext, Flux<ReactorQLRecord>>> mappers = new LinkedHashMap<String, Function<ReactorQLContext, Flux<ReactorQLRecord>>>();
        int index = 0;
        for (Expression expression : from) {
            if (!(expression instanceof FromItem)) {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684from\u8868\u8fbe\u5f0f:" + expression);
            }
            String exprAlias = ((FromItem)expression).getAlias() == null ? "$" + index : ((FromItem)expression).getAlias().getName();
            mappers.put(exprAlias, FromFeature.createFromMapperByFrom((FromItem)expression, metadata));
            ++index;
        }
        return this.create(alias, mappers);
    }

    protected Function<ReactorQLContext, Flux<ReactorQLRecord>> create(String alias, Map<String, Function<ReactorQLContext, Flux<ReactorQLRecord>>> mappers) {
        return ctx -> Flux.zip((Iterable)mappers.entrySet().stream().map(e -> ((Flux)((Function)e.getValue()).apply(ctx)).map(record -> Tuples.of(e.getKey(), (Object)record))).collect(Collectors.toList()), zipResult -> {
            HashMap<String, Object> val = new HashMap<String, Object>();
            ReactorQLRecord record = ReactorQLRecord.newRecord(alias, val, ctx);
            for (Object o : zipResult) {
                Tuple2 tp2 = (Tuple2)o;
                String name = ((ReactorQLRecord)tp2.getT2()).getName() == null ? (String)tp2.getT1() : ((ReactorQLRecord)tp2.getT2()).getName();
                val.put(name, ((ReactorQLRecord)tp2.getT2()).getRecord());
            }
            return record;
        });
    }

    @Override
    public String getId() {
        return ID;
    }
}

