/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.distinct;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.DistinctFeature;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class DefaultDistinctFeature
implements DistinctFeature {
    @Override
    public Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> createDistinctMapper(Distinct distinct, final ReactorQLMetadata metadata) {
        List items = distinct.getOnSelectItems();
        if (items == null) {
            return flux -> flux.distinct(ReactorQLRecord::getRecord);
        }
        final ArrayList<Function<ReactorQLRecord, Mono<Object>>> keySelector = new ArrayList<Function<ReactorQLRecord, Mono<Object>>>();
        for (SelectItem item : items) {
            item.accept(new SelectItemVisitor(){

                public void visit(AllColumns allColumns) {
                    keySelector.add(record -> Mono.justOrEmpty((Object)record.getRecord()));
                }

                public void visit(AllTableColumns allTableColumns) {
                    String tname = allTableColumns.getTable().getAlias() != null ? allTableColumns.getTable().getAlias().getName() : allTableColumns.getTable().getName();
                    keySelector.add(record -> Mono.justOrEmpty(record.getRecord(tname)));
                }

                public void visit(SelectExpressionItem selectExpressionItem) {
                    Expression expr = selectExpressionItem.getExpression();
                    Function<ReactorQLRecord, ? extends Publisher<?>> mapper = ValueMapFeature.createMapperNow(expr, metadata);
                    keySelector.add(record -> Mono.from((Publisher)((Publisher)mapper.apply((ReactorQLRecord)record))));
                }
            });
        }
        return this.createDistinct(keySelector);
    }

    protected Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> createDistinct(List<Function<ReactorQLRecord, Mono<Object>>> keySelector) {
        return flux -> flux.flatMap(record -> Flux.fromIterable((Iterable)keySelector).flatMap(mapper -> (Mono)mapper.apply(record)).collectList().map(list -> Tuples.of((Object)list, (Object)record))).distinct(Tuple2::getT1).map(Tuple2::getT2);
    }

    @Override
    public String getId() {
        return FeatureId.Distinct.defaultId.getId();
    }
}

