/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.cluster.task;

import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.task.Task;
import org.jetlinks.rule.engine.api.task.TaskSnapshot;
import org.jetlinks.rule.engine.cluster.scheduler.SchedulerRpcService;
import reactor.core.publisher.Mono;

public class RemoteTask
implements Task {
    private final String id;
    private final String name;
    private final String workerId;
    private final String schedulerId;
    private final SchedulerRpcService rpcService;
    private ScheduleJob job;

    public Mono<Void> setJob(ScheduleJob job) {
        this.job = job;
        return this.rpcService.setTaskJob(this.id, job);
    }

    private Mono<Void> operation(SchedulerRpcService.TaskOperation operation) {
        return this.rpcService.taskOperation(this.id, operation);
    }

    public Mono<Void> reload() {
        return this.operation(SchedulerRpcService.TaskOperation.RELOAD);
    }

    public Mono<Void> start() {
        return this.operation(SchedulerRpcService.TaskOperation.START);
    }

    public Mono<Void> pause() {
        return this.operation(SchedulerRpcService.TaskOperation.PAUSE);
    }

    public Mono<Void> shutdown() {
        return this.operation(SchedulerRpcService.TaskOperation.SHUTDOWN);
    }

    public Mono<Void> execute(RuleData data) {
        return this.rpcService.executeTask(this.id, data).then();
    }

    public Mono<Task.State> getState() {
        return this.rpcService.getTaskState(this.id);
    }

    public Mono<Void> debug(boolean debug) {
        return this.operation(debug ? SchedulerRpcService.TaskOperation.ENABLE_DEBUG : SchedulerRpcService.TaskOperation.DISABLE_DEBUG);
    }

    public Mono<Long> getLastStateTime() {
        return this.rpcService.getLastStateTime(this.id);
    }

    public Mono<Long> getStartTime() {
        return this.rpcService.getStartTime(this.id);
    }

    public Mono<TaskSnapshot> dump() {
        return this.rpcService.dumpTask(this.id);
    }

    public RemoteTask(String id, String name, String workerId, String schedulerId, SchedulerRpcService rpcService, ScheduleJob job) {
        this.id = id;
        this.name = name;
        this.workerId = workerId;
        this.schedulerId = schedulerId;
        this.rpcService = rpcService;
        this.job = job;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public String getSchedulerId() {
        return this.schedulerId;
    }

    public SchedulerRpcService getRpcService() {
        return this.rpcService;
    }

    public ScheduleJob getJob() {
        return this.job;
    }
}

