/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.light;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.AbstractLightMetaProperty;
import org.joda.beans.impl.light.ImmutableLightMetaProperty;
import org.joda.beans.impl.light.LightBeanBuilder;
import org.joda.beans.impl.light.LightMetaProperty;
import org.joda.beans.impl.light.MutableLightMetaProperty;

public final class LightMetaBean<T extends Bean>
implements TypedMetaBean<T> {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Class<T> beanType;
    private final Map<String, MetaProperty<?>> metaPropertyMap;
    private final Function<Object[], T> constructorFn;
    private final Object[] constructionData;

    @Deprecated
    public static <B extends Bean> LightMetaBean<B> of(Class<B> beanClass) {
        return new LightMetaBean<B>(beanClass);
    }

    @Deprecated
    private LightMetaBean(Class<T> beanType) {
        Method[] methods;
        if (beanType == null) {
            throw new NullPointerException("Bean class must not be null");
        }
        this.beanType = beanType;
        LinkedHashMap<String, AbstractLightMetaProperty> map = new LinkedHashMap<String, AbstractLightMetaProperty>();
        Field[] fields = beanType.getDeclaredFields();
        ArrayList propertyTypes = new ArrayList();
        for (Field field : fields) {
            if (!Modifier.isStatic(field.getModifiers()) && field.getAnnotation(PropertyDefinition.class) != null) {
                PropertyDefinition pdef = field.getAnnotation(PropertyDefinition.class);
                String name = field.getName();
                if (pdef.get().equals("field") || pdef.get().startsWith("optional") || pdef.get().equals("")) {
                    field.setAccessible(true);
                    if (!ImmutableBean.class.isAssignableFrom(beanType)) {
                        map.put(name, MutableLightMetaProperty.of(this, field, name, propertyTypes.size()));
                    } else {
                        map.put(name, ImmutableLightMetaProperty.of((MetaBean)this, field, name, propertyTypes.size()));
                    }
                } else {
                    String getterName = "get" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
                    Method getMethod = null;
                    if (field.getType() == Boolean.TYPE) {
                        getMethod = LightMetaBean.findGetMethod(beanType, "is" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1));
                    }
                    if (getMethod == null && (getMethod = LightMetaBean.findGetMethod(beanType, getterName)) == null) {
                        throw new IllegalArgumentException("Unable to find property getter: " + beanType.getSimpleName() + "." + getterName + "()");
                    }
                    getMethod.setAccessible(true);
                    if (ImmutableBean.class.isAssignableFrom(beanType)) {
                        map.put(name, ImmutableLightMetaProperty.of(this, field, getMethod, name, propertyTypes.size()));
                    } else {
                        String setterName = "set" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
                        Method setMethod = LightMetaBean.findSetMethod(beanType, setterName, field.getType());
                        if (setMethod == null) {
                            throw new IllegalArgumentException("Unable to find property setter: " + beanType.getSimpleName() + "." + setterName + "()");
                        }
                        map.put(name, MutableLightMetaProperty.of(this, field, getMethod, setMethod, name, propertyTypes.size()));
                    }
                }
                propertyTypes.add(field.getType());
                continue;
            }
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            String name = field.getName();
            field.setAccessible(true);
            if (!ImmutableBean.class.isAssignableFrom(beanType) && !Modifier.isFinal(field.getModifiers())) {
                map.put(name, MutableLightMetaProperty.of(this, field, name, propertyTypes.size()));
            } else {
                map.put(name, ImmutableLightMetaProperty.of((MetaBean)this, field, name, propertyTypes.size()));
            }
            propertyTypes.add(field.getType());
        }
        for (Method method : methods = beanType.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getAnnotation(DerivedProperty.class) == null || !method.getName().startsWith("get") || method.getName().length() <= 3 || !Character.isUpperCase(method.getName().charAt(3)) || method.getParameterTypes().length != 0) continue;
            String methodName = method.getName();
            String propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            if (!Modifier.isPublic(method.getModifiers())) {
                method.setAccessible(true);
            }
            ImmutableLightMetaProperty mp = ImmutableLightMetaProperty.of((MetaBean)this, method, propertyName, -1);
            map.put(propertyName, mp);
        }
        this.metaPropertyMap = Collections.unmodifiableMap(map);
        Constructor<T> construct = LightMetaBean.findConstructor(beanType, propertyTypes);
        construct.setAccessible(true);
        this.constructionData = LightMetaBean.buildConstructionData(construct);
        this.constructorFn = args -> this.build(construct, (Object[])args);
    }

    @Deprecated
    private T build(Constructor<T> constructor, Object[] args) {
        try {
            return (T)((Bean)constructor.newInstance(args));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Bean cannot be created: " + this.beanName() + " from " + args, ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException("Bean cannot be created: " + this.beanName() + " from " + args, ex);
        }
        catch (InstantiationException ex) {
            throw new UnsupportedOperationException("Bean cannot be created: " + this.beanName() + " from " + args, ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex);
        }
    }

    public static <B extends Bean> LightMetaBean<B> of(Class<B> beanType, MethodHandles.Lookup lookup) {
        return new LightMetaBean<B>(beanType, lookup, LightMetaBean.fieldNames(beanType), EMPTY_OBJECT_ARRAY);
    }

    @Deprecated
    public static <B extends Bean> LightMetaBean<B> of(Class<B> beanType, MethodHandles.Lookup lookup, Object ... defaultValues) {
        return new LightMetaBean<B>(beanType, lookup, LightMetaBean.fieldNames(beanType), defaultValues);
    }

    private static String[] fieldNames(Class<?> beanType) {
        Field[] fields = (Field[])Stream.of(beanType.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers()) && f.getAnnotation(PropertyDefinition.class) != null).toArray(Field[]::new);
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            fieldNames.add(fields[i].getName());
        }
        return fieldNames.toArray(new String[fieldNames.size()]);
    }

    public static <B extends Bean> LightMetaBean<B> of(Class<B> beanType, MethodHandles.Lookup lookup, String[] fieldNames, Object ... defaultValues) {
        return new LightMetaBean<B>(beanType, lookup, fieldNames, defaultValues);
    }

    private LightMetaBean(Class<T> beanType, MethodHandles.Lookup lookup, String[] fieldNames, Object[] defaultValues) {
        Method[] methods;
        if (beanType == null) {
            throw new NullPointerException("Bean class must not be null");
        }
        if (lookup == null) {
            throw new NullPointerException("Lookup must not be null");
        }
        if (fieldNames == null) {
            throw new NullPointerException("Field names array must not be null");
        }
        if (defaultValues == null) {
            throw new NullPointerException("Default values array must not be null");
        }
        if (defaultValues.length > 0 && defaultValues.length != fieldNames.length) {
            throw new IllegalArgumentException("Number of default values must match number of fields");
        }
        this.beanType = beanType;
        LinkedHashMap map = new LinkedHashMap();
        ArrayList propertyTypes = new ArrayList();
        for (int i = 0; i < fieldNames.length; ++i) {
            Method[] field;
            String fieldName = fieldNames[i];
            try {
                field = beanType.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException ex) {
                throw new IllegalArgumentException(ex);
            }
            if (Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Field must not be static");
            }
            if (field.getAnnotation(PropertyDefinition.class) == null) {
                throw new IllegalArgumentException("Field must have PropertyDefinition annotation");
            }
            PropertyDefinition pdef = field.getAnnotation(PropertyDefinition.class);
            String name = field.getName();
            if (pdef.get().equals("field") || pdef.get().startsWith("optional") || pdef.get().equals("")) {
                map.put(name, LightMetaProperty.of((MetaBean)this, (Field)field, lookup, name, propertyTypes.size()));
            } else {
                String setterName;
                String getterName = "get" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
                Method getMethod = null;
                if (field.getType() == Boolean.TYPE) {
                    getMethod = LightMetaBean.findGetMethod(beanType, "is" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1));
                }
                if (getMethod == null && (getMethod = LightMetaBean.findGetMethod(beanType, getterName)) == null) {
                    throw new IllegalArgumentException("Unable to find property getter: " + beanType.getSimpleName() + "." + getterName + "()");
                }
                Method setMethod = null;
                if (!ImmutableBean.class.isAssignableFrom(beanType) && (setMethod = LightMetaBean.findSetMethod(beanType, setterName = "set" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1), field.getType())) == null) {
                    throw new IllegalArgumentException("Unable to find property setter: " + beanType.getSimpleName() + "." + setterName + "()");
                }
                map.put(name, LightMetaProperty.of(this, (Field)field, getMethod, setMethod, lookup, name, propertyTypes.size()));
            }
            propertyTypes.add(field.getType());
        }
        Constructor<T> constructor = LightMetaBean.findConstructor(beanType, propertyTypes);
        if (defaultValues.length == 0) {
            defaultValues = LightMetaBean.buildConstructionData(constructor);
        }
        for (Method method : methods = beanType.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getAnnotation(DerivedProperty.class) == null || !method.getName().startsWith("get") || method.getName().length() <= 3 || !Character.isUpperCase(method.getName().charAt(3)) || method.getParameterTypes().length != 0) continue;
            String methodName = method.getName();
            String propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            LightMetaProperty mp = LightMetaProperty.of((MetaBean)this, method, lookup, propertyName, -1);
            map.put(propertyName, mp);
        }
        this.metaPropertyMap = Collections.unmodifiableMap(map);
        this.constructionData = defaultValues;
        MethodHandle handle = LightMetaBean.findConstructorHandle(beanType, lookup, constructor);
        this.constructorFn = args -> this.build(handle, (Object[])args);
    }

    private static Method findGetMethod(Class<? extends Bean> beanType, String getterName) {
        try {
            return beanType.getDeclaredMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            try {
                return beanType.getMethod(getterName, new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                return null;
            }
        }
    }

    private static Method findSetMethod(Class<? extends Bean> beanType, String setterName, Class<?> fieldType) {
        try {
            return beanType.getDeclaredMethod(setterName, fieldType);
        }
        catch (NoSuchMethodException ex) {
            Method[] methods = beanType.getMethods();
            ArrayList<Method> potential = new ArrayList<Method>();
            for (Method method : methods) {
                if (!method.getName().equals(setterName) || method.getParameterTypes().length != 1) continue;
                potential.add(method);
            }
            if (potential.size() == 1) {
                return (Method)potential.get(0);
            }
            for (Method method : potential) {
                if (!method.getParameterTypes()[0].equals(fieldType)) continue;
                return method;
            }
            return null;
        }
    }

    private static <T extends Bean> MethodHandle findConstructorHandle(Class<T> beanType, MethodHandles.Lookup lookup, Constructor<?> constructor) {
        try {
            MethodType constructorType = MethodType.methodType(Void.TYPE, constructor.getParameterTypes());
            MethodHandle baseHandle = lookup.findConstructor(beanType, constructorType).asSpreader(Object[].class, constructor.getParameterTypes().length);
            return baseHandle.asType(baseHandle.type().changeReturnType(Bean.class));
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Unable to find constructor: " + beanType.getSimpleName());
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Unable to access constructor: " + beanType.getSimpleName());
        }
    }

    private static <T extends Bean> Constructor<T> findConstructor(Class<T> beanType, List<Class<?>> propertyTypes) {
        Class[] types = propertyTypes.toArray(new Class[propertyTypes.size()]);
        try {
            Constructor<T> con = beanType.getDeclaredConstructor(types);
            return con;
        }
        catch (NoSuchMethodException ex) {
            Constructor<?>[] cons = beanType.getDeclaredConstructors();
            Constructor<?> match = null;
            for (int i = 0; i < cons.length; ++i) {
                Constructor<?> con = cons[i];
                Class<?>[] conTypes = con.getParameterTypes();
                if (conTypes.length != types.length) continue;
                for (int j = 0; j < types.length && conTypes[j].isAssignableFrom(types[j]); ++j) {
                }
                if (match != null) {
                    throw new UnsupportedOperationException("Unable to find constructor: More than one matches");
                }
                match = con;
            }
            if (match == null) {
                String msg = "Unable to find constructor: " + beanType.getSimpleName() + "(";
                for (Class type : types) {
                    msg = msg + Objects.toString(type.getName(), "<null>");
                }
                msg = msg + ")";
                throw new UnsupportedOperationException(msg, ex);
            }
            return match;
        }
    }

    private static Object[] buildConstructionData(Constructor<?> constructor) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] == Boolean.TYPE) {
                args[i] = false;
                continue;
            }
            if (parameterTypes[i] == Integer.TYPE) {
                args[i] = 0;
                continue;
            }
            if (parameterTypes[i] == Long.TYPE) {
                args[i] = 0L;
                continue;
            }
            if (parameterTypes[i] == Short.TYPE) {
                args[i] = (short)0;
                continue;
            }
            if (parameterTypes[i] == Byte.TYPE) {
                args[i] = (byte)0;
                continue;
            }
            if (parameterTypes[i] == Float.TYPE) {
                args[i] = Float.valueOf(0.0f);
                continue;
            }
            if (parameterTypes[i] == Double.TYPE) {
                args[i] = 0.0;
                continue;
            }
            if (parameterTypes[i] != Character.TYPE) continue;
            args[i] = Character.valueOf('\u0000');
        }
        return args;
    }

    private T build(MethodHandle handle, Object[] args) {
        try {
            return (T)handle.invokeExact(args);
        }
        catch (Error ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Bean cannot be created: " + this.beanName() + " from " + Arrays.toString(args), ex);
        }
    }

    T build(Object[] args) {
        return (T)((Bean)this.constructorFn.apply(args));
    }

    @Override
    public boolean isBuildable() {
        return true;
    }

    @Override
    public BeanBuilder<T> builder() {
        return new LightBeanBuilder(this, (Object[])this.constructionData.clone());
    }

    @Override
    public Class<T> beanType() {
        return this.beanType;
    }

    @Override
    public Map<String, MetaProperty<?>> metaPropertyMap() {
        return this.metaPropertyMap;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LightMetaBean) {
            LightMetaBean other = (LightMetaBean)obj;
            return this.beanType.equals(other.beanType);
        }
        return false;
    }

    public int hashCode() {
        return this.beanType.hashCode() + 3;
    }

    public String toString() {
        return "MetaBean:" + this.beanName();
    }
}

