/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.bin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerCategory;
import org.joda.beans.ser.SerIterator;
import org.joda.beans.ser.SerOptional;
import org.joda.beans.ser.SerTypeMapper;
import org.joda.beans.ser.bin.MsgPackOutput;

public class JodaBeanBinWriter {
    private final JodaBeanSer settings;
    private MsgPackOutput output;
    private String basePackage;
    private Map<Class<?>, String> knownTypes = new HashMap();

    public JodaBeanBinWriter(JodaBeanSer settings) {
        this.settings = settings;
    }

    public byte[] write(Bean bean) {
        return this.write(bean, true);
    }

    public byte[] write(Bean bean, boolean rootType) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try {
            this.write(bean, rootType, baos);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return baos.toByteArray();
    }

    public void write(Bean bean, OutputStream output) throws IOException {
        this.write(bean, true, output);
    }

    public void write(Bean bean, boolean rootType, OutputStream output) throws IOException {
        if (bean == null) {
            throw new NullPointerException("bean");
        }
        if (output == null) {
            throw new NullPointerException("output");
        }
        this.output = new MsgPackOutput(output);
        this.writeRoot(bean, rootType);
    }

    private void writeRoot(Bean bean, boolean rootType) throws IOException {
        this.output.writeArrayHeader(2);
        this.output.writeInt(1);
        this.writeBean(bean, bean.getClass(), rootType ? RootType.ROOT_WITH_TYPE : RootType.ROOT_WITHOUT_TYPE);
    }

    private void writeBean(Bean bean, Class<?> declaredType, RootType rootTypeFlag) throws IOException {
        Object value;
        int count = bean.metaBean().metaPropertyCount();
        MetaProperty[] props = new MetaProperty[count];
        Object[] values = new Object[count];
        int size = 0;
        for (MetaProperty<?> metaProperty : bean.metaBean().metaPropertyIterable()) {
            if (!metaProperty.style().isSerializable() || (value = SerOptional.extractValue(metaProperty, bean)) == null) continue;
            props[size] = metaProperty;
            values[size++] = value;
        }
        if (rootTypeFlag == RootType.ROOT_WITH_TYPE || rootTypeFlag == RootType.NOT_ROOT && bean.getClass() != declaredType) {
            String typeStr = SerTypeMapper.encodeType(bean.getClass(), this.settings, this.basePackage, this.knownTypes);
            if (rootTypeFlag == RootType.ROOT_WITH_TYPE) {
                this.basePackage = bean.getClass().getPackage().getName() + ".";
            }
            this.output.writeMapHeader(size + 1);
            this.output.writeExtensionString(32, typeStr);
            this.output.writeNil();
        } else {
            this.output.writeMapHeader(size);
        }
        for (int i = 0; i < size; ++i) {
            MetaProperty metaProperty = props[i];
            value = values[i];
            this.output.writeString(metaProperty.name());
            Class<?> propType = SerOptional.extractType(metaProperty, bean.getClass());
            if (value instanceof Bean) {
                if (this.settings.getConverter().isConvertible(value.getClass())) {
                    this.writeSimple(propType, value);
                    continue;
                }
                this.writeBean((Bean)value, propType, RootType.NOT_ROOT);
                continue;
            }
            SerIterator itemIterator = this.settings.getIteratorFactory().create(value, metaProperty, bean.getClass());
            if (itemIterator != null) {
                this.writeElements(itemIterator);
                continue;
            }
            this.writeSimple(propType, value);
        }
    }

    private void writeElements(SerIterator itemIterator) throws IOException {
        if (itemIterator.metaTypeRequired()) {
            this.output.writeMapHeader(1);
            this.output.writeExtensionString(34, itemIterator.metaTypeName());
        }
        if (itemIterator.category() == SerCategory.MAP) {
            this.writeMap(itemIterator);
        } else if (itemIterator.category() == SerCategory.COUNTED) {
            this.writeCounted(itemIterator);
        } else if (itemIterator.category() == SerCategory.TABLE) {
            this.writeTable(itemIterator);
        } else if (itemIterator.category() == SerCategory.GRID) {
            this.writeGrid(itemIterator);
        } else {
            this.writeArray(itemIterator);
        }
    }

    private void writeArray(SerIterator itemIterator) throws IOException {
        this.output.writeArrayHeader(itemIterator.size());
        while (itemIterator.hasNext()) {
            itemIterator.next();
            this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator);
        }
    }

    private void writeMap(SerIterator itemIterator) throws IOException {
        this.output.writeMapHeader(itemIterator.size());
        while (itemIterator.hasNext()) {
            itemIterator.next();
            Object key = itemIterator.key();
            if (key == null) {
                throw new IllegalArgumentException("Unable to write map key as it cannot be null: " + key);
            }
            this.writeObject(itemIterator.keyType(), key, null);
            this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator);
        }
    }

    private void writeTable(SerIterator itemIterator) throws IOException {
        this.output.writeArrayHeader(itemIterator.size());
        while (itemIterator.hasNext()) {
            itemIterator.next();
            this.output.writeArrayHeader(3);
            this.writeObject(itemIterator.keyType(), itemIterator.key(), null);
            this.writeObject(itemIterator.columnType(), itemIterator.column(), null);
            this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator);
        }
    }

    private void writeGrid(SerIterator itemIterator) throws IOException {
        int rows = itemIterator.dimensionSize(0);
        int columns = itemIterator.dimensionSize(1);
        int totalSize = rows * columns;
        if (itemIterator.size() < totalSize / 4) {
            this.output.writeArrayHeader(itemIterator.size() + 2);
            this.output.writeInt(rows);
            this.output.writeInt(columns);
            while (itemIterator.hasNext()) {
                itemIterator.next();
                this.output.writeArrayHeader(3);
                this.output.writeInt((Integer)itemIterator.key());
                this.output.writeInt((Integer)itemIterator.column());
                this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator);
            }
        } else {
            this.output.writeArrayHeader(totalSize + 2);
            this.output.writeInt(rows);
            this.output.writeInt(columns);
            for (int row = 0; row < rows; ++row) {
                for (int column = 0; column < columns; ++column) {
                    this.writeObject(itemIterator.valueType(), itemIterator.value(row, column), itemIterator);
                }
            }
        }
    }

    private void writeCounted(SerIterator itemIterator) throws IOException {
        this.output.writeMapHeader(itemIterator.size());
        while (itemIterator.hasNext()) {
            itemIterator.next();
            this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator);
            this.output.writeInt(itemIterator.count());
        }
    }

    private void writeObject(Class<?> declaredType, Object obj, SerIterator parentIterator) throws IOException {
        if (obj == null) {
            this.output.writeNil();
        } else if (this.settings.getConverter().isConvertible(obj.getClass())) {
            this.writeSimple(declaredType, obj);
        } else if (obj instanceof Bean) {
            this.writeBean((Bean)obj, declaredType, RootType.NOT_ROOT);
        } else if (parentIterator != null) {
            SerIterator childIterator = this.settings.getIteratorFactory().createChild(obj, parentIterator);
            if (childIterator != null) {
                this.writeElements(childIterator);
            } else {
                this.writeSimple(declaredType, obj);
            }
        } else {
            this.writeSimple(declaredType, obj);
        }
    }

    private void writeSimple(Class<?> declaredType, Object value) throws IOException {
        String typeStr;
        Class<?> realType = value.getClass();
        if (realType == Integer.class) {
            this.output.writeInt((Integer)value);
            return;
        }
        if (realType == Double.class) {
            this.output.writeDouble((Double)value);
            return;
        }
        if (realType == Float.class) {
            this.output.writeFloat(((Float)value).floatValue());
            return;
        }
        if (realType == Boolean.class) {
            this.output.writeBoolean((Boolean)value);
            return;
        }
        Class effectiveType = declaredType;
        if (declaredType == Object.class) {
            if (realType != String.class) {
                effectiveType = this.settings.getConverter().findTypedConverter(realType).getEffectiveType();
                typeStr = SerTypeMapper.encodeType(effectiveType, this.settings, this.basePackage, this.knownTypes);
                this.output.writeMapHeader(1);
                this.output.writeExtensionString(33, typeStr);
            } else {
                effectiveType = realType;
            }
        } else if (!this.settings.getConverter().isConvertible(declaredType)) {
            effectiveType = this.settings.getConverter().findTypedConverter(realType).getEffectiveType();
            typeStr = SerTypeMapper.encodeType(effectiveType, this.settings, this.basePackage, this.knownTypes);
            this.output.writeMapHeader(1);
            this.output.writeExtensionString(33, typeStr);
        }
        if (realType == Long.class) {
            this.output.writeLong((Long)value);
            return;
        }
        if (realType == Short.class) {
            this.output.writeInt(((Short)value).shortValue());
            return;
        }
        if (realType == Byte.class) {
            this.output.writeInt(((Byte)value).byteValue());
            return;
        }
        if (realType == byte[].class) {
            this.output.writeBytes((byte[])value);
            return;
        }
        try {
            String converted = this.settings.getConverter().convertToString(effectiveType, value);
            if (converted == null) {
                throw new IllegalArgumentException("Unable to write because converter returned a null string: " + value);
            }
            this.output.writeString(converted);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Unable to convert type " + effectiveType.getName() + " declared as " + declaredType.getName(), ex);
        }
    }

    static enum RootType {
        ROOT_WITH_TYPE,
        ROOT_WITHOUT_TYPE,
        NOT_ROOT;

    }
}

