/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.direct;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.MetaProperty;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.MinimalMetaProperty;

public final class MinimalMetaBean<T extends Bean>
implements TypedMetaBean<T> {
    private final Class<T> beanType;
    private final Supplier<BeanBuilder<T>> builderSupplier;
    private final Map<String, MetaProperty<?>> metaPropertyMap;
    private final Map<String, String> aliasMap;

    @Deprecated
    @SafeVarargs
    public static <B extends Bean> MinimalMetaBean<B> of(Class<B> beanType, Supplier<BeanBuilder<B>> builderSupplier, Function<B, Object> ... getters) {
        if (getters == null) {
            throw new NullPointerException("Getter functions must not be null");
        }
        return new MinimalMetaBean<B>(beanType, MinimalMetaBean.fieldNames(beanType), builderSupplier, Arrays.asList(getters), null);
    }

    @SafeVarargs
    public static <B extends Bean> MinimalMetaBean<B> of(Class<B> beanType, String[] fieldNames, Supplier<BeanBuilder<B>> builderSupplier, Function<B, Object> ... getters) {
        if (getters == null) {
            throw new NullPointerException("Getter functions must not be null");
        }
        return new MinimalMetaBean<B>(beanType, fieldNames, builderSupplier, Arrays.asList(getters), null);
    }

    @Deprecated
    public static <B extends Bean> MinimalMetaBean<B> of(Class<B> beanType, Supplier<BeanBuilder<B>> builderSupplier, List<Function<B, Object>> getters, List<BiConsumer<B, Object>> setters) {
        if (getters == null) {
            throw new NullPointerException("Getter functions must not be null");
        }
        if (setters == null) {
            throw new NullPointerException("Setter functions must not be null");
        }
        return new MinimalMetaBean<B>(beanType, MinimalMetaBean.fieldNames(beanType), builderSupplier, getters, setters);
    }

    public static <B extends Bean> MinimalMetaBean<B> of(Class<B> beanType, String[] fieldNames, Supplier<BeanBuilder<B>> builderSupplier, List<Function<B, Object>> getters, List<BiConsumer<B, Object>> setters) {
        if (getters == null) {
            throw new NullPointerException("Getter functions must not be null");
        }
        if (setters == null) {
            throw new NullPointerException("Setter functions must not be null");
        }
        return new MinimalMetaBean<B>(beanType, fieldNames, builderSupplier, getters, setters);
    }

    private MinimalMetaBean(Class<T> beanType, String[] fieldNames, Supplier<BeanBuilder<T>> builderSupplier, List<Function<T, Object>> getters, List<BiConsumer<T, Object>> setters) {
        Method[] methods;
        if (beanType == null) {
            throw new NullPointerException("Bean class must not be null");
        }
        if (builderSupplier == null) {
            throw new NullPointerException("Supplier of BeanBuilder must not be null");
        }
        if (fieldNames == null) {
            throw new NullPointerException("Field names must not be null");
        }
        if (fieldNames.length != getters.size()) {
            throw new IllegalArgumentException("Number of getter functions must match number of fields");
        }
        if (setters != null && fieldNames.length != setters.size()) {
            throw new IllegalArgumentException("Number of setter functions must match number of fields");
        }
        this.beanType = beanType;
        this.builderSupplier = builderSupplier;
        LinkedHashMap map = new LinkedHashMap();
        for (int i = 0; i < fieldNames.length; ++i) {
            Field field;
            String fieldName = fieldNames[i];
            try {
                field = beanType.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException ex) {
                throw new IllegalArgumentException(ex);
            }
            if (Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Field must not be static");
            }
            if (field.getAnnotation(PropertyDefinition.class) == null) {
                throw new IllegalArgumentException("Field must have PropertyDefinition annotation");
            }
            map.put(fieldName, new MinimalMetaProperty(this, fieldName, field, getters.get(i), setters != null ? setters.get(i) : null));
        }
        for (Method method : methods = beanType.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || method.getAnnotation(DerivedProperty.class) == null || !method.getName().startsWith("get") || method.getName().length() <= 3 || !Character.isUpperCase(method.getName().charAt(3)) || method.getParameterTypes().length != 0) continue;
            String methodName = method.getName();
            String propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            MinimalMetaProperty mp = new MinimalMetaProperty(this, method, propertyName);
            map.put(propertyName, mp);
        }
        this.metaPropertyMap = Collections.unmodifiableMap(map);
        this.aliasMap = new HashMap<String, String>();
    }

    private static String[] fieldNames(Class<?> beanType) {
        Field[] fields = (Field[])Stream.of(beanType.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers()) && f.getAnnotation(PropertyDefinition.class) != null).toArray(Field[]::new);
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            fieldNames.add(fields[i].getName());
        }
        return fieldNames.toArray(new String[fieldNames.size()]);
    }

    private MinimalMetaBean(Class<T> beanType, Supplier<BeanBuilder<T>> builderSupplier, Map<String, MetaProperty<?>> metaPropertyMap, Map<String, String> aliasMap) {
        this.beanType = beanType;
        this.builderSupplier = builderSupplier;
        this.metaPropertyMap = metaPropertyMap;
        this.aliasMap = aliasMap;
    }

    public MinimalMetaBean<T> withAlias(String alias, String realName) {
        if (!this.metaPropertyMap.containsKey(realName)) {
            throw new IllegalArgumentException("Invalid property name: " + realName);
        }
        HashMap<String, String> aliasMap = new HashMap<String, String>(this.aliasMap);
        aliasMap.put(alias, realName);
        return new MinimalMetaBean<T>(this.beanType, this.builderSupplier, this.metaPropertyMap, aliasMap);
    }

    @Override
    public boolean isBuildable() {
        return true;
    }

    @Override
    public BeanBuilder<T> builder() {
        return this.builderSupplier.get();
    }

    @Override
    public Class<T> beanType() {
        return this.beanType;
    }

    @Override
    public <R> MetaProperty<R> metaProperty(String propertyName) {
        MetaProperty<?> mp = this.metaPropertyMap().get(this.aliasMap.getOrDefault(propertyName, propertyName));
        if (mp == null) {
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }
        return mp;
    }

    @Override
    public Map<String, MetaProperty<?>> metaPropertyMap() {
        return this.metaPropertyMap;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MinimalMetaBean) {
            MinimalMetaBean other = (MinimalMetaBean)obj;
            return this.beanType.equals(other.beanType);
        }
        return false;
    }

    public int hashCode() {
        return this.beanType.hashCode() + 3;
    }

    public String toString() {
        return "MetaBean:" + this.beanName();
    }
}

