/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.bin;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.joda.beans.ser.bin.MsgPackInput;

final class MsgPackVisualizer
extends MsgPackInput {
    private String indent = "";
    private StringBuilder buf = new StringBuilder(1024);

    MsgPackVisualizer(byte[] bytes) {
        super(bytes);
    }

    MsgPackVisualizer(InputStream stream) {
        super(stream);
    }

    MsgPackVisualizer(DataInputStream stream) {
        super(stream);
    }

    String visualizeData() {
        this.readAll();
        return this.buf.toString();
    }

    @Override
    void readArrayItem() throws IOException {
        this.indent = this.indent + "- ";
        super.readArrayItem();
        this.indent = this.indent.substring(0, this.indent.length() - 2);
    }

    @Override
    void readMapKey() throws IOException {
        this.indent = this.indent + "= ";
        super.readMapKey();
        this.indent = this.indent.substring(0, this.indent.length() - 2);
    }

    @Override
    void readMapValue() throws IOException {
        this.indent = this.indent + "  ";
        super.readMapValue();
        this.indent = this.indent.substring(0, this.indent.length() - 2);
    }

    @Override
    void handleObjectStart() {
        this.buf.append(this.indent);
        this.indent = this.indent.replace("-", " ").replace("=", " ");
    }

    @Override
    void handleBoolean(boolean bool) {
        this.buf.append(bool).append(System.lineSeparator());
    }

    @Override
    void handleNil() {
        this.buf.append("nil").append(System.lineSeparator());
    }

    @Override
    void handleInt(int value) {
        this.buf.append("int " + value).append(System.lineSeparator());
    }

    @Override
    void handleUnsignedLong(long value) {
        this.buf.append("int " + value + " unsigned").append(System.lineSeparator());
    }

    @Override
    void handleSignedLong(long value) {
        this.buf.append("int " + value + " signed").append(System.lineSeparator());
    }

    @Override
    void handleFloat(float value) {
        this.buf.append("flt " + value).append(System.lineSeparator());
    }

    @Override
    void handleDouble(double value) {
        this.buf.append("dbl " + value).append(System.lineSeparator());
    }

    @Override
    void handleUnknown(byte b) {
        this.buf.append("Unknown - " + String.format("%02X ", b)).append(System.lineSeparator());
    }

    @Override
    void handleString(String str) {
        this.buf.append("str '" + str + '\'').append(System.lineSeparator());
    }

    @Override
    void handleArrayHeader(int size) {
        this.buf.append("arr (" + size + ")").append(System.lineSeparator());
    }

    @Override
    void handleMapHeader(int size) {
        this.buf.append("map (" + size + ")").append(System.lineSeparator());
    }

    @Override
    void handleBinary(byte[] bytes) {
        this.buf.append("bin '");
        for (byte b : bytes) {
            this.buf.append(MsgPackVisualizer.toHex(b));
        }
        this.buf.append("'").append(System.lineSeparator());
    }

    @Override
    void handleExtension(int type, boolean numeric, byte[] bytes) throws IOException {
        String str;
        if (numeric) {
            int value = 0;
            for (byte b : bytes) {
                value = value << 8 | b;
            }
            str = Integer.toString(value);
        } else {
            str = new String(bytes, UTF_8);
        }
        this.buf.append("ext type=").append(type).append(" '").append(str).append("'");
        switch (type) {
            case 32: {
                this.buf.append(" (bean)");
                break;
            }
            case 33: {
                this.buf.append(" (data)");
                break;
            }
            case 34: {
                this.buf.append(" (meta)");
                break;
            }
            case 35: {
                this.buf.append(" (refkey)");
                break;
            }
            case 36: {
                this.buf.append(" (ref)");
                break;
            }
        }
        this.buf.append(System.lineSeparator());
    }
}

