/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.json;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerIterable;
import org.joda.beans.ser.SerIteratorFactory;
import org.joda.beans.ser.json.AbstractJsonReader;
import org.joda.beans.ser.json.JsonInput;

public class JodaBeanSimpleJsonReader
extends AbstractJsonReader {
    public JodaBeanSimpleJsonReader(JodaBeanSer settings) {
        super(settings);
    }

    public <T> T read(String input, Class<T> rootType) {
        JodaBeanUtils.notNull(input, "input");
        return this.read(new StringReader(input), rootType);
    }

    public <T> T read(Reader input, Class<T> rootType) {
        JodaBeanUtils.notNull(input, "input");
        JodaBeanUtils.notNull(rootType, "rootType");
        try {
            JsonInput jsonInput = new JsonInput(input);
            return this.parseRoot(jsonInput, rootType);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    SerIterable parseUnknownArray(Class<?> declaredType) {
        if (declaredType.isArray()) {
            return SerIteratorFactory.array(declaredType.getComponentType());
        }
        return SerIteratorFactory.list(Object.class, Collections.emptyList());
    }

    @Override
    SerIterable parseUnknownObject(Class<?> declaredType) {
        return SerIteratorFactory.map(String.class, Object.class, Collections.emptyList());
    }
}

