/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.joda.beans.Bean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.JodaBeanSerFormat;

public class JodaBeanSmartReader {
    private final JodaBeanSer settings;

    JodaBeanSmartReader(JodaBeanSer settings) {
        this.settings = settings;
    }

    public boolean isKnownFormat(byte[] input) {
        return this.determineFormat(input) != JodaBeanSerFormat.UNKNOWN;
    }

    public boolean isKnownFormat(InputStream input) {
        return this.determineFormat(input) != JodaBeanSerFormat.UNKNOWN;
    }

    private JodaBeanSerFormat determineFormat(byte[] input) {
        if (input.length < 2) {
            return JodaBeanSerFormat.UNKNOWN;
        }
        if (input.length >= 4 && input[0] == -17 && input[1] == -69 && input[2] == -65) {
            if (input[3] == 60 && this.isXml(input, 3)) {
                return JodaBeanSerFormat.XML_UTF8;
            }
            if (input[3] == 123 && this.isJson(input, 3)) {
                return JodaBeanSerFormat.JSON_UTF8;
            }
            return JodaBeanSerFormat.UNKNOWN;
        }
        if (input[0] == 60 && this.isXml(input, 0)) {
            return JodaBeanSerFormat.XML;
        }
        if (input[0] == 123 && this.isJson(input, 0)) {
            return JodaBeanSerFormat.JSON;
        }
        if (input[0] == -108 && input[1] == 2) {
            return JodaBeanSerFormat.BIN;
        }
        if (input[0] == -110 && input[1] == 1) {
            return JodaBeanSerFormat.BIN;
        }
        return JodaBeanSerFormat.UNKNOWN;
    }

    private boolean isXml(byte[] bytes, int pos) {
        String str = new String(bytes, pos, bytes.length - pos, StandardCharsets.UTF_8);
        return str.contains("<bean ") || str.contains("<bean>");
    }

    private boolean isJson(byte[] bytes, int pos) {
        for (int i = pos + 1; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 125 || b == 34) {
                return true;
            }
            if (b == 32 || b == 9 || b == 13 || b == 10) continue;
            return false;
        }
        return false;
    }

    private JodaBeanSerFormat determineFormat(InputStream input) {
        if (!input.markSupported()) {
            throw new IllegalArgumentException("Input stream does not support mark/reset");
        }
        byte[] buf = new byte[128];
        try {
            input.mark(128);
            int readCount = JodaBeanSmartReader.read(input, buf, 128);
            buf = Arrays.copyOf(buf, readCount);
            input.reset();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return this.determineFormat(buf);
    }

    private static int read(InputStream in, byte[] buf, int len) throws IOException {
        int pos;
        int result;
        for (pos = 0; pos < len && (result = in.read(buf, pos, len - pos)) != -1; pos += result) {
        }
        return pos;
    }

    public Bean read(byte[] input) {
        return this.read(input, Bean.class);
    }

    public <T> T read(byte[] input, Class<T> rootType) {
        JodaBeanUtils.notNull(input, "input");
        return this.read(new ByteArrayInputStream(input), rootType);
    }

    public Bean read(InputStream input) {
        return this.read(input, Bean.class);
    }

    public <T> T read(InputStream input, Class<T> rootType) {
        JodaBeanUtils.notNull(input, "input");
        JodaBeanUtils.notNull(rootType, "rootType");
        BufferedInputStream buffered = this.buffer(input);
        JodaBeanSerFormat format = this.determineFormat(buffered);
        return format.read(buffered, rootType, this.settings);
    }

    private BufferedInputStream buffer(InputStream input) {
        if (input.getClass() == BufferedInputStream.class) {
            return (BufferedInputStream)input;
        }
        return new BufferedInputStream(input);
    }
}

