/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.insert.InsertModel;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.InsertMapping;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.PropertyMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;

public class InsertDSL<T> {
    private T record;
    private SqlTable table;
    private List<InsertMapping> columnMappings = new ArrayList<InsertMapping>();

    private InsertDSL(T record, SqlTable table) {
        this.record = record;
        this.table = table;
    }

    public <F> ColumnMappingFinisher<F> map(SqlColumn<F> column) {
        return new ColumnMappingFinisher<F>(column);
    }

    public InsertModel<T> build() {
        return InsertModel.withRecord(this.record).withTable(this.table).withColumnMappings(this.columnMappings).build();
    }

    public static <T> IntoGatherer<T> insert(T record) {
        return new IntoGatherer(record);
    }

    public class ColumnMappingFinisher<F> {
        private SqlColumn<F> column;

        public ColumnMappingFinisher(SqlColumn<F> column) {
            this.column = column;
        }

        public InsertDSL<T> toProperty(String property) {
            InsertDSL.this.columnMappings.add(PropertyMapping.of(this.column, property));
            return InsertDSL.this;
        }

        public InsertDSL<T> toPropertyWhenPresent(String property, Supplier<?> valueSupplier) {
            if (valueSupplier.get() != null) {
                this.toProperty(property);
            }
            return InsertDSL.this;
        }

        public InsertDSL<T> toNull() {
            InsertDSL.this.columnMappings.add(NullMapping.of(this.column));
            return InsertDSL.this;
        }

        public InsertDSL<T> toConstant(String constant) {
            InsertDSL.this.columnMappings.add(ConstantMapping.of(this.column, constant));
            return InsertDSL.this;
        }

        public InsertDSL<T> toStringConstant(String constant) {
            InsertDSL.this.columnMappings.add(StringConstantMapping.of(this.column, constant));
            return InsertDSL.this;
        }
    }

    public static class IntoGatherer<T> {
        private T record;

        private IntoGatherer(T record) {
            this.record = record;
        }

        public InsertDSL<T> into(SqlTable table) {
            return new InsertDSL(this.record, table);
        }
    }
}

