/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.mybatis.dynamic.sql.insert.render.FieldAndValue;

public class FieldAndValueCollector {
    private List<FieldAndValue> fieldsAndValue = new ArrayList<FieldAndValue>();

    public void add(FieldAndValue fieldAndValue) {
        this.fieldsAndValue.add(fieldAndValue);
    }

    public FieldAndValueCollector merge(FieldAndValueCollector other) {
        this.fieldsAndValue.addAll(other.fieldsAndValue);
        return this;
    }

    public String columnsPhrase() {
        return this.fieldsAndValue.stream().map(FieldAndValue::fieldName).collect(Collectors.joining(", ", "(", ")"));
    }

    public String valuesPhrase() {
        return this.fieldsAndValue.stream().map(FieldAndValue::valuePhrase).collect(Collectors.joining(", ", "values (", ")"));
    }

    public String multiRowInsertValuesPhrase(int rowCount) {
        return IntStream.range(0, rowCount).mapToObj(this::toSingleRowOfValues).collect(Collectors.joining(", ", "values ", ""));
    }

    private String toSingleRowOfValues(int row) {
        return this.fieldsAndValue.stream().map(fmv -> fmv.valuePhrase(row)).collect(Collectors.joining(", ", "(", ")"));
    }

    public static Collector<FieldAndValue, FieldAndValueCollector, FieldAndValueCollector> collect() {
        return Collector.of(FieldAndValueCollector::new, FieldAndValueCollector::add, FieldAndValueCollector::merge, new Collector.Characteristics[0]);
    }
}

