/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.select.function.AbstractFunction;

public abstract class AbstractMultipleColumnArithmeticFunction<T extends Number, U extends AbstractMultipleColumnArithmeticFunction<T, U>>
extends AbstractFunction<T, AbstractMultipleColumnArithmeticFunction<T, U>> {
    protected BasicColumn secondColumn;
    protected List<BasicColumn> subsequentColumns = new ArrayList<BasicColumn>();

    protected AbstractMultipleColumnArithmeticFunction(BindableColumn<T> firstColumn, BasicColumn secondColumn, List<BasicColumn> subsequentColumns) {
        super(firstColumn);
        this.secondColumn = Objects.requireNonNull(secondColumn);
        this.subsequentColumns.addAll(subsequentColumns);
    }

    @Override
    public String renderWithTableAlias(TableAliasCalculator tableAliasCalculator) {
        return Stream.of(Stream.of(this.column), Stream.of(this.secondColumn), this.subsequentColumns.stream()).flatMap(Function.identity()).map(column -> column.renderWithTableAlias(tableAliasCalculator)).collect(Collectors.joining(this.padOperator(), "(", ")"));
    }

    private String padOperator() {
        return " " + this.operator() + " ";
    }

    protected abstract String operator();
}

