/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.Collection;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsIn<T>
extends AbstractListValueCondition<T> {
    protected IsIn(Collection<T> values, UnaryOperator<Stream<T>> valueStreamTransformer) {
        super(values, valueStreamTransformer);
    }

    protected IsIn(Collection<T> values) {
        super(values);
    }

    @Override
    public String renderCondition(String columnName, Stream<String> placeholders) {
        return StringUtilities.spaceAfter(columnName) + placeholders.collect(Collectors.joining(",", "in (", ")"));
    }

    public IsIn<T> then(UnaryOperator<Stream<T>> valueStreamTransformer) {
        return new IsIn<T>(this.values, valueStreamTransformer);
    }

    public static <T> IsIn<T> of(Collection<T> values) {
        return new IsIn<T>(values);
    }
}

