/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.render;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.where.render.RenderedCriterion;
import org.mybatis.dynamic.sql.where.render.WhereConditionVisitor;

public class CriterionRenderer<T> {
    private SqlCriterion<T> sqlCriterion;
    private AtomicInteger sequence;
    private RenderingStrategy renderingStrategy;
    private TableAliasCalculator tableAliasCalculator;
    private String parameterName;

    private CriterionRenderer(Builder<T> builder) {
        this.sqlCriterion = Objects.requireNonNull(((Builder)builder).sqlCriterion);
        this.sequence = Objects.requireNonNull(((Builder)builder).sequence);
        this.renderingStrategy = Objects.requireNonNull(((Builder)builder).renderingStrategy);
        this.tableAliasCalculator = Objects.requireNonNull(((Builder)builder).tableAliasCalculator);
        this.parameterName = ((Builder)builder).parameterName;
    }

    public Optional<RenderedCriterion> render() {
        Optional<FragmentAndParameters> initialCondition = this.renderCondition();
        List<RenderedCriterion> subCriteria = this.sqlCriterion.mapSubCriteria(this::renderSubCriterion).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return new RenderedCriterion.Builder().withConnector(this.sqlCriterion.connector()).withInitialCondition(initialCondition).withSubCriteria(subCriteria).build();
    }

    private <S> Optional<RenderedCriterion> renderSubCriterion(SqlCriterion<S> subCriterion) {
        return CriterionRenderer.withCriterion(subCriterion).withSequence(this.sequence).withRenderingStrategy(this.renderingStrategy).withTableAliasCalculator(this.tableAliasCalculator).withParameterName(this.parameterName).build().render();
    }

    private Optional<FragmentAndParameters> renderCondition() {
        if (!this.sqlCriterion.condition().shouldRender()) {
            return Optional.empty();
        }
        WhereConditionVisitor<T> visitor = WhereConditionVisitor.withColumn(this.sqlCriterion.column()).withRenderingStrategy(this.renderingStrategy).withSequence(this.sequence).withTableAliasCalculator(this.tableAliasCalculator).withParameterName(this.parameterName).build();
        return (Optional)this.sqlCriterion.condition().accept(visitor);
    }

    public static <T> Builder<T> withCriterion(SqlCriterion<T> sqlCriterion) {
        return new Builder<T>().withCriterion(sqlCriterion);
    }

    public static class Builder<T> {
        private SqlCriterion<T> sqlCriterion;
        private AtomicInteger sequence;
        private RenderingStrategy renderingStrategy;
        private TableAliasCalculator tableAliasCalculator;
        private String parameterName;

        public Builder<T> withCriterion(SqlCriterion<T> sqlCriterion) {
            this.sqlCriterion = sqlCriterion;
            return this;
        }

        public Builder<T> withSequence(AtomicInteger sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder<T> withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder<T> withTableAliasCalculator(TableAliasCalculator tableAliasCalculator) {
            this.tableAliasCalculator = tableAliasCalculator;
            return this;
        }

        public Builder<T> withParameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public CriterionRenderer<T> build() {
            return new CriterionRenderer(this);
        }
    }
}

