/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.loader.archive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.jar.Manifest;
import org.noear.solon.loader.archive.Archive;
import org.noear.solon.loader.data.RandomAccessData;
import org.noear.solon.loader.jar.JarEntryData;
import org.noear.solon.loader.jar.JarEntryFilter;
import org.noear.solon.loader.jar.JarFile;
import org.noear.solon.loader.util.AsciiBytes;

public class JarFileArchive
extends Archive {
    private static final AsciiBytes UNPACK_MARKER = new AsciiBytes("UNPACK:");
    private static final int BUFFER_SIZE = 32768;
    private final JarFile jarFile;
    private final List<Archive.Entry> entries;
    private URL url;
    private File tempUnpackFolder;

    public JarFileArchive(File file) throws IOException {
        this(file, null);
    }

    public JarFileArchive(File file, URL url) throws IOException {
        this(new JarFile(file));
        this.url = url;
    }

    public JarFileArchive(JarFile jarFile) {
        this.jarFile = jarFile;
        ArrayList<JarFileEntry> jarFileEntries = new ArrayList<JarFileEntry>();
        for (JarEntryData data : jarFile) {
            jarFileEntries.add(new JarFileEntry(data));
        }
        this.entries = Collections.unmodifiableList(jarFileEntries);
    }

    @Override
    public URL getUrl() throws MalformedURLException {
        if (this.url != null) {
            return this.url;
        }
        return this.jarFile.getUrl();
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jarFile.getManifest();
    }

    @Override
    public List<Archive> getNestedArchives(Archive.EntryFilter filter) throws IOException {
        ArrayList<Archive> nestedArchives = new ArrayList<Archive>();
        for (Archive.Entry entry : this.getEntries()) {
            if (!filter.matches(entry)) continue;
            nestedArchives.add(this.getNestedArchive(entry));
        }
        return Collections.unmodifiableList(nestedArchives);
    }

    @Override
    public Collection<Archive.Entry> getEntries() {
        return Collections.unmodifiableCollection(this.entries);
    }

    protected Archive getNestedArchive(Archive.Entry entry) throws IOException {
        JarEntryData data = ((JarFileEntry)entry).getJarEntryData();
        if (data.getComment().startsWith(UNPACK_MARKER)) {
            return this.getUnpackedNestedArchive(data);
        }
        JarFile jarFile = this.jarFile.getNestedJarFile(data);
        return new JarFileArchive(jarFile);
    }

    private Archive getUnpackedNestedArchive(JarEntryData data) throws IOException {
        File file;
        String name = data.getName().toString();
        if (name.lastIndexOf("/") != -1) {
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        if (!(file = new File(this.getTempUnpackFolder(), name)).exists() || file.length() != (long)data.getSize()) {
            this.unpack(data, file);
        }
        return new JarFileArchive(file, file.toURI().toURL());
    }

    private File getTempUnpackFolder() {
        if (this.tempUnpackFolder == null) {
            File tempFolder = new File(System.getProperty("java.io.tmpdir"));
            this.tempUnpackFolder = this.createUnpackFolder(tempFolder);
        }
        return this.tempUnpackFolder;
    }

    private File createUnpackFolder(File parent) {
        int attempts = 0;
        while (attempts++ < 1000) {
            String fileName = new File(this.jarFile.getName()).getName();
            File unpackFolder = new File(parent, fileName + "-libs-" + UUID.randomUUID());
            if (!unpackFolder.mkdirs()) continue;
            return unpackFolder;
        }
        throw new IllegalStateException("Failed to create unpack folder in directory '" + parent + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpack(JarEntryData data, File file) throws IOException {
        try (InputStream inputStream = data.getData().getInputStream(RandomAccessData.ResourceAccess.ONCE);
             FileOutputStream outputStream = new FileOutputStream(file);){
            byte[] buffer = new byte[32768];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
            outputStream.flush();
        }
    }

    @Override
    public Archive getFilteredArchive(final Archive.EntryRenameFilter filter) throws IOException {
        JarFile filteredJar = this.jarFile.getFilteredJarFile(new JarEntryFilter(){

            @Override
            public AsciiBytes apply(AsciiBytes name, JarEntryData entryData) {
                return filter.apply(name, new JarFileEntry(entryData));
            }
        });
        return new JarFileArchive(filteredJar);
    }

    private static class JarFileEntry
    implements Archive.Entry {
        private final JarEntryData entryData;

        JarFileEntry(JarEntryData entryData) {
            this.entryData = entryData;
        }

        public JarEntryData getJarEntryData() {
            return this.entryData;
        }

        @Override
        public boolean isDirectory() {
            return this.entryData.isDirectory();
        }

        @Override
        public AsciiBytes getName() {
            return this.entryData.getName();
        }
    }
}

