/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.nutz.lang.util.Disks;
import org.nutz.lang.util.FileVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public abstract class AbstractNbMojo
extends AbstractMojo {
    @Parameter(property="nutzboot.mainClass", defaultValue="")
    protected String mainClass;
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    protected File basedir;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    protected File target;
    @Parameter(property="nutzboot.debug", defaultValue="false")
    protected boolean debug;

    public static String searchMainClass(File target, final Log log) {
        final ArrayList possibleMainClasses = new ArrayList();
        Disks.visitFile((File)target, (FileVisitor)new FileVisitor(){

            public void visit(File file) {
                try (FileInputStream fis = new FileInputStream(file);){
                    ClassReader cr = new ClassReader((InputStream)fis);
                    ClassNode node = new ClassNode();
                    cr.accept((ClassVisitor)node, 8);
                    for (MethodNode method : node.methods) {
                        if (!method.name.equals("main") || !Modifier.isPublic(method.access) || !Modifier.isStatic(method.access)) continue;
                        for (AbstractInsnNode insn : method.instructions.toArray()) {
                            if (!(insn instanceof TypeInsnNode)) continue;
                            TypeInsnNode type = (TypeInsnNode)insn;
                            if (!"org/nutz/boot/NbApp".equals(type.desc)) continue;
                            possibleMainClasses.add(node.name.replace('/', '.'));
                        }
                    }
                }
                catch (Throwable e) {
                    log.info((CharSequence)("bad class file? " + file.getAbsolutePath()), e);
                }
            }
        }, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".class") && !f.getName().contains("$");
            }
        });
        if (possibleMainClasses.size() > 0) {
            return (String)possibleMainClasses.get(0);
        }
        return null;
    }
}

