/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.maven;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nutz.boot.maven.AbstractRepoMojo;
import org.nutz.lang.Strings;

@Mojo(name="repo-ssh-upload")
public class RepoSshUploadMojo
extends AbstractRepoMojo {
    @Parameter(property="repo.ssh.user")
    private String repoSshUser;
    @Parameter(property="repo.ssh.server")
    private String repoSshServer;
    @Parameter(property="repo.ssh.uploadpath")
    private String repoSshUploadpath;
    @Parameter(property="repo.ssh.keypath")
    private String repoSshKeypath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            new ProcessBuilder("which", "scp").start();
        }
        catch (IOException e) {
            throw new MojoFailureException("repo-ssh-upload task just run in *uix now!!!");
        }
        if (this.file == null) {
            if (this.project == null) {
                throw new MojoFailureException("require repo.file or pom.xml!!!");
            }
            this.file = this.project.getArtifact().getFile();
        }
        if (!this.file.exists()) {
            throw new MojoFailureException("file not exist!!! " + this.file);
        }
        if (Strings.isEmpty((CharSequence)this.repoSshUser)) {
            throw new MojoFailureException("require repo.ssh.user!!!");
        }
        if (Strings.isEmpty((CharSequence)this.repoSshServer)) {
            throw new MojoFailureException("require repo.ssh.server!!!");
        }
        if (Strings.isEmpty((CharSequence)this.repoSshUploadpath)) {
            throw new MojoFailureException("require repo.ssh.uploadpath!!!");
        }
        String uploadpath = String.join((CharSequence)"/", this.repoSshUploadpath.split("/"));
        String uploadFileName = this.file.getName();
        List attachedArtifacts = this.project.getAttachedArtifacts();
        Artifact artifact = (Artifact)attachedArtifacts.get(attachedArtifacts.size() - 1);
        if (null != artifact && "war".equals(artifact.getClassifier())) {
            uploadFileName = artifact.getFile().getName();
        }
        ProcessBuilder processBuilder = new ProcessBuilder("scp", this.file.getPath(), String.format("%s@%s:%s/%s", this.repoSshUser, this.repoSshServer, uploadpath, uploadFileName));
        if (!Strings.isEmpty((CharSequence)this.repoSshKeypath)) {
            processBuilder.command().add(1, "-i");
            processBuilder.command().add(2, this.repoSshKeypath);
        }
        Log log = this.getLog();
        log.info((CharSequence)("upload file " + uploadFileName + " to path " + uploadpath));
        try {
            Process process = processBuilder.start();
            InputStream errorStream = process.getErrorStream();
            if (errorStream != null) {
                new BufferedReader(new InputStreamReader(errorStream)).lines().forEach(error -> log.error((CharSequence)error));
                throw new MojoFailureException("repo-ssh-upload task fail");
            }
        }
        catch (IOException e) {
            log.error((CharSequence)"repo-ssh-upload task fail", (Throwable)e);
            throw new MojoFailureException("ssh upload has some problem, check about ssh params PLZ");
        }
    }
}

