/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.maven;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.nutz.boot.maven.AbstractRepoMojo;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;

@Mojo(name="repo-upload")
public class RepoUploadMojo
extends AbstractRepoMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        block19: {
            if (this.file == null) {
                if (this.project == null) {
                    throw new MojoFailureException("require repo.file or pom.xml!!!");
                }
                this.file = this.project.getArtifact().getFile();
            }
            if (!this.file.exists()) {
                throw new MojoFailureException("file not exist!!! " + this.file);
            }
            try (FileInputStream ins = new FileInputStream(this.file);){
                String url = this.repoUrl + "/" + this.repoUser + "/" + this.repoAppName + "/" + this.repoAppVersion + "/?fileName=" + URLEncoder.encode(this.file.getName(), "UTF-8");
                this.getLog().info((CharSequence)("Upload URL=" + url));
                Request request = Request.create((String)url, (Request.METHOD)Request.METHOD.POST);
                request.setParams((Map)new NutMap("fileName", (Object)this.file.getName()));
                request.getHeader().set("Content-Type", "application/octet-stream");
                request.getHeader().set("Content-Length", "" + this.file.length());
                request.getHeader().set("Connection", "close");
                String token = this.readRepoToken();
                if (!Strings.isBlank((CharSequence)token)) {
                    request.getHeader().set("Repo-Token", token);
                }
                request.setInputStream((InputStream)ins);
                this.getLog().info((CharSequence)("Uploading... size=" + this.file.length()));
                Response resp = Sender.create((Request)request).send();
                if (resp.isOK()) {
                    this.getLog().info((CharSequence)"Upload Complete");
                    break block19;
                }
                this.getLog().info((CharSequence)("Upload FAIL!!! respCode=" + resp.getStatus() + "\r\n" + resp.getContent()));
                throw new MojoFailureException("respCode=" + resp.getStatus());
            }
            catch (IOException e) {
                this.getLog().info((CharSequence)"Upload FAIL!!!", (Throwable)e);
                throw new MojoFailureException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

