/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.maven;

import java.io.File;
import java.lang.reflect.Field;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.exec.ExecJavaMojo;
import org.nutz.boot.maven.AbstractNbMojo;
import org.nutz.lang.Strings;

@Mojo(name="run", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class RunMojo
extends ExecJavaMojo {
    @Parameter(required=false, property="exec.mainClass", alias="nutzboot.mainClass")
    private String mainClass;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    protected File target;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (Strings.isBlank((CharSequence)this.mainClass)) {
            this.mainClass = AbstractNbMojo.searchMainClass(this.target, log);
        }
        if (!Strings.isBlank((CharSequence)this.mainClass)) {
            try {
                Field field = ExecJavaMojo.class.getDeclaredField("mainClass");
                field.setAccessible(true);
                field.set((Object)this, this.mainClass);
            }
            catch (Exception e) {
                log.error((CharSequence)"bad bad bad", (Throwable)e);
                throw new MojoFailureException("bad bad bad", (Throwable)e);
            }
        }
        if (this.project != null) {
            System.setProperty("app.build.version", this.project.getVersion());
            System.setProperty("app.build.groupId", this.project.getGroupId());
            System.setProperty("app.build.artifactId", this.project.getArtifactId());
        }
        super.execute();
    }
}

