/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.shade.mojo.ShadeMojo;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.AppendingTransformer;
import org.apache.maven.plugins.shade.resource.ManifestResourceTransformer;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.apache.maven.plugins.shade.resource.ServicesResourceTransformer;
import org.apache.maven.project.MavenProject;
import org.nutz.boot.maven.AbstractNbMojo;
import org.nutz.lang.Encoding;
import org.nutz.lang.Mirror;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;

@Mojo(name="shade", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class NbShadeMojo
extends ShadeMojo {
    @Parameter(required=false, property="nutzboot.mainClass")
    private String mainClass;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    protected File target;
    @Parameter(required=false, property="nutzboot.dst")
    protected File dst;
    @Parameter(required=false)
    private boolean compression = true;
    protected Field transformersField = ShadeMojo.class.getDeclaredField("transformers");
    @Parameter(defaultValue="${project}", readonly=true, required=false)
    protected MavenProject project2;

    public NbShadeMojo() throws Exception {
        this.transformersField.setAccessible(true);
    }

    public void execute() throws MojoExecutionException {
        if ("pom".equals(this.project2.getPackaging())) {
            return;
        }
        if (Strings.isBlank((CharSequence)this.mainClass)) {
            this.mainClass = AbstractNbMojo.searchMainClass(this.target, this.getLog());
        }
        if (Strings.isBlank((CharSequence)this.mainClass)) {
            this.getLog().info((CharSequence)"MainLaucher not found, skip this action!!!");
            return;
        }
        try {
            ResourceTransformer[] transformers = (ResourceTransformer[])this.transformersField.get((Object)this);
            if (transformers == null) {
                transformers = new ResourceTransformer[]{};
            }
            ArrayList<Object> transformers2 = new ArrayList<Object>();
            boolean hasServicesResourceTransformer = false;
            boolean hasManifestResourceTransformer = false;
            for (ResourceTransformer rt : transformers) {
                if (rt instanceof ServicesResourceTransformer) {
                    hasServicesResourceTransformer = true;
                }
                if (rt instanceof ManifestResourceTransformer) {
                    hasManifestResourceTransformer = true;
                }
                transformers2.add(rt);
            }
            if (!hasServicesResourceTransformer) {
                transformers2.add(new ServicesResourceTransformer());
            }
            if (!hasManifestResourceTransformer) {
                ManifestResourceTransformer rt = new ManifestResourceTransformer(){

                    public void modifyOutputStream(JarOutputStream jos) throws IOException {
                        super.modifyOutputStream(jos);
                        try {
                            JarEntry en = new JarEntry("build.version");
                            jos.putNextEntry(en);
                            StringBuilder sb = new StringBuilder();
                            sb.append("app.build.version=").append(NbShadeMojo.this.project2.getVersion()).append("\r\n");
                            sb.append("app.build.groupId=").append(NbShadeMojo.this.project2.getGroupId()).append("\r\n");
                            sb.append("app.build.artifactId=").append(NbShadeMojo.this.project2.getArtifactId()).append("\r\n");
                            sb.append("buildNumber=").append("_");
                            jos.write(sb.toString().getBytes());
                            jos.closeEntry();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                };
                if (Strings.isBlank((CharSequence)this.mainClass)) {
                    this.mainClass = AbstractNbMojo.searchMainClass(this.target, this.getLog());
                }
                Mirror.me(ManifestResourceTransformer.class).setValue((Object)rt, "mainClass", (Object)this.mainClass);
                transformers2.add(rt);
            }
            AppendingTransformer at = new AppendingTransformer();
            Mirror.me(AppendingTransformer.class).setValue((Object)at, "resource", (Object)"META-INF/nutz/org.nutz.boot.starter.NbStarter");
            transformers2.add(at);
            at = new AppendingTransformer();
            Mirror.me(AppendingTransformer.class).setValue((Object)at, "resource", (Object)"META-INF/cxf/bus-extensions.txt");
            transformers2.add(at);
            at = new AppendingTransformer();
            Mirror.me(AppendingTransformer.class).setValue((Object)at, "resource", (Object)"META-INF/spring.handlers");
            transformers2.add(at);
            at = new AppendingTransformer();
            Mirror.me(AppendingTransformer.class).setValue((Object)at, "resource", (Object)"META-INF/spring.schemas");
            transformers2.add(at);
            at = new AppendingTransformer();
            Mirror.me(AppendingTransformer.class).setValue((Object)at, "resource", (Object)"META-INF/dubbo/com.alibaba.dubbo.rpc.Filter");
            transformers2.add(at);
            transformers2.add(new ResourceTransformer(){

                public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
                    NbShadeMojo.this.getLog().info((CharSequence)("Remove " + resource));
                }

                public void modifyOutputStream(JarOutputStream os) throws IOException {
                }

                public boolean hasTransformedResource() {
                    return false;
                }

                public boolean canTransformResource(String resource) {
                    if (resource.startsWith("META-INF")) {
                        if (resource.endsWith(".SF") || resource.endsWith(".DSA") || resource.endsWith(".RSA")) {
                            return true;
                        }
                        if (resource.startsWith("META-INF/NOTICE")) {
                            return true;
                        }
                        if (resource.startsWith("META-INF/LICENSE")) {
                            return true;
                        }
                    }
                    if (resource.startsWith("rest-management-private-classpath/")) {
                        return true;
                    }
                    return resource.equals("build.version");
                }
            });
            this.transformersField.set((Object)this, transformers2.toArray(new ResourceTransformer[transformers2.size()]));
        }
        catch (Throwable e) {
            throw new MojoExecutionException("fail to get/set transformers", e);
        }
        if (this.dst != null) {
            Mirror.me((Object)((Object)this)).setValue((Object)this, "outputFile", (Object)new File(this.dst, this.project2.getArtifactId() + "-" + this.project2.getVersion() + ".jar"));
        }
        super.execute();
        if (!this.compression) {
            this.getLog().info((CharSequence)"making uncompress jar ...");
            File mainZip = this.project2.getArtifact().getFile();
            long time = System.currentTimeMillis();
            FileTime t2 = FileTime.fromMillis(time);
            File tmpZip = new File(mainZip + ".zip");
            try (ZipInputStream ins = new ZipInputStream((InputStream)new FileInputStream(mainZip), Encoding.CHARSET_UTF8);
                 ZipOutputStream out = new ZipOutputStream((OutputStream)new FileOutputStream(tmpZip), Encoding.CHARSET_UTF8);){
                out.setLevel(0);
                ZipEntry en = null;
                ZipEntry en2 = null;
                while ((en = ins.getNextEntry()) != null) {
                    en2 = new ZipEntry(en.getName());
                    en2.setLastModifiedTime(t2);
                    en2.setTime(time);
                    en2.setCreationTime(t2);
                    en2.setLastAccessTime(t2);
                    out.putNextEntry(en2);
                    if (!en.isDirectory()) {
                        Streams.write((OutputStream)out, (InputStream)ins);
                    }
                    out.closeEntry();
                }
                out.flush();
            }
            catch (Exception e) {
                throw new MojoExecutionException("error when doing unzip", e);
            }
            this.getLog().info((CharSequence)"replace origin jar ...");
            mainZip.renameTo(new File(mainZip.getParent(), "shade-" + mainZip.getName()));
            tmpZip.renameTo(mainZip);
        }
    }
}

