/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.AttachedArtifact;
import org.nutz.boot.maven.AbstractNbMojo;
import org.nutz.lang.Encoding;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;

@Mojo(name="war")
public class WarMojo
extends AbstractNbMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="nutzboot.mainPackage", defaultValue="")
    protected String mainPackage;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (Strings.isBlank((CharSequence)this.mainClass)) {
            this.mainClass = AbstractNbMojo.searchMainClass(this.target, this.getLog());
        }
        File jarFile = this.project.getArtifact().getFile();
        Log log = this.getLog();
        log.info((CharSequence)("Convert " + jarFile.getName()));
        try {
            File dstFile = new File(jarFile.getParentFile(), this.project.getArtifactId() + ".war");
            try (ZipInputStream sourceZip = new ZipInputStream(new FileInputStream(jarFile));
                 ZipOutputStream dstZip = new ZipOutputStream((OutputStream)new FileOutputStream(dstFile), Encoding.CHARSET_UTF8);){
                ZipEntry sourceEn = null;
                String webXml = null;
                String nbStarterMark = "";
                block20: while ((sourceEn = sourceZip.getNextEntry()) != null) {
                    String sourceName;
                    String targetName = sourceName = sourceEn.getName();
                    if (sourceName.startsWith("static/") || sourceName.startsWith("webapp/")) {
                        if (sourceName.equals("static/") || sourceName.equals("webapp/")) continue;
                        targetName = sourceName.substring("static/".length());
                        if ("WEB-INF/web.xml".equalsIgnoreCase(targetName)) {
                            log.info((CharSequence)"found web.xml, need rewrite");
                            webXml = new String(Streams.readBytes((InputStream)sourceZip), "UTF-8");
                            continue;
                        }
                    } else {
                        for (String pkg : Arrays.asList("org/eclipse/jetty/server", "org/eclipse/jetty/webapp", "org/eclipse/jetty/websocket/jsr356/server", "io/undertow", "org/apache/catalina", "javax/servlet", "javax/websocket", "META-INF/services/javax.servlet", "META-INF/services/javax.websocket", "org/nutz/boot/starter/jetty", "org/nutz/boot/starter/tomcat", "org/nutz/boot/starter/undertow")) {
                            if (!sourceName.startsWith(pkg)) continue;
                            continue block20;
                        }
                        if ("META-INF/nutz/org.nutz.boot.starter.NbStarter".equals(sourceName)) {
                            nbStarterMark = new String(Streams.readBytes((InputStream)sourceZip), Encoding.CHARSET_UTF8);
                            nbStarterMark = nbStarterMark.replace("org.nutz.boot.starter.jetty.JettyStarter", "");
                            nbStarterMark = nbStarterMark.replace("org.nutz.boot.starter.tomcat.TomcatStarter", "");
                            nbStarterMark = nbStarterMark.replace("org.nutz.boot.starter.undertow.UndertowStarter", "");
                            continue;
                        }
                        targetName = "WEB-INF/classes/" + sourceName;
                    }
                    dstZip.putNextEntry(new ZipEntry(targetName));
                    Streams.write((OutputStream)dstZip, (InputStream)sourceZip);
                    dstZip.closeEntry();
                }
                if (!Strings.isBlank((CharSequence)nbStarterMark)) {
                    dstZip.putNextEntry(new ZipEntry("WEB-INF/classes/META-INF/nutz/org.nutz.boot.starter.NbStarter"));
                    dstZip.write(nbStarterMark.getBytes(Encoding.CHARSET_UTF8));
                    dstZip.closeEntry();
                }
                webXml = this.createOrRewriteWebXml(webXml, this.mainClass);
                dstZip.putNextEntry(new ZipEntry("WEB-INF/web.xml"));
                dstZip.write(webXml.getBytes(Encoding.CHARSET_UTF8));
                dstZip.closeEntry();
                dstZip.finish();
                dstZip.flush();
                AttachedArtifact artifact = new AttachedArtifact(this.project.getArtifact(), "", "war", null);
                artifact.setFile(dstFile);
                this.project.addAttachedArtifact((Artifact)artifact);
            }
        }
        catch (Exception e) {
            log.error((CharSequence)"convert fail", (Throwable)e);
        }
    }

    protected String createOrRewriteWebXml(String sourceWebXml, String mainClass) {
        StringBuilder sb = new StringBuilder();
        sb.append("<listener><listener-class>org.nutz.boot.starter.servlet3.NbServletContextListener</listener-class></listener>\r\n");
        sb.append("<context-param><param-name>nutzboot.mainClass</param-name><param-value>").append(mainClass).append("</param-value></context-param>\r\n");
        if (Strings.isNotBlank((CharSequence)this.mainPackage)) {
            sb.append("<context-param><param-name>nutzboot.mainPackage</param-name><param-value>").append(this.mainPackage).append("</param-value></context-param>\r\b");
        }
        if (Strings.isBlank((CharSequence)sourceWebXml)) {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<web-app>\r\n    " + sb + "\r\n</web-app>";
        }
        int index = sourceWebXml.indexOf(62, sourceWebXml.indexOf("<web-app8")) + 1;
        return sourceWebXml.substring(0, index) + sb + sourceWebXml.substring(index);
    }
}

