/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.redisson;

import java.io.IOException;
import java.lang.reflect.Field;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.api.RedissonRxClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.CborJacksonCodec;
import org.redisson.codec.FstCodec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.codec.KryoCodec;
import org.redisson.codec.LZ4Codec;
import org.redisson.codec.MsgPackJacksonCodec;
import org.redisson.codec.SerializationCodec;
import org.redisson.codec.SmileJacksonCodec;
import org.redisson.codec.SnappyCodec;
import org.redisson.codec.SnappyCodecV2;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;

@IocBean
public class RedissonBeans {
    public static final String PRE = "redisson.";
    @Inject
    protected PropertiesProxy conf;

    @IocBean(name="redissonConfig")
    public Config createredissonConfig() throws IOException {
        String mode;
        if (this.conf.has("redisson.config.fromJson")) {
            String fromJson = this.conf.get("redisson.config.fromJson");
            return Config.fromJSON((String)fromJson);
        }
        if (this.conf.has("redisson.config.fromYaml")) {
            String fromYaml = this.conf.get("redisson.config.fromYaml");
            return Config.fromYAML((String)fromYaml);
        }
        Config config = (Config)this.conf.make(Config.class, PRE);
        switch (mode = this.conf.get("redisson.mode", "single")) {
            case "single": {
                SingleServerConfig ssc = config.useSingleServer();
                ssc.setAddress(this.conf.get("redisson.single.address", "redis://127.0.0.1:6379"));
                this.setupBeanByConf(ssc, "redisson.single.");
                break;
            }
            case "masterslave": {
                MasterSlaveServersConfig mssc = config.useMasterSlaveServers();
                mssc.setMasterAddress(this.conf.check("redisson.masterslave.masterAddress"));
                mssc.addSlaveAddress(Strings.splitIgnoreBlank((String)this.conf.check("redisson.masterslave.slaveAddress")));
                this.setupBeanByConf(mssc, "redisson.masterslave.");
                break;
            }
            case "cluster": {
                ClusterServersConfig csc = config.useClusterServers();
                csc.addNodeAddress(new String[]{this.conf.check("redisson.cluster.nodeAddress")});
                this.setupBeanByConf(csc, "redisson.cluster.");
                break;
            }
            case "replicated": {
                ReplicatedServersConfig rsc = config.useReplicatedServers();
                rsc.addNodeAddress(new String[]{this.conf.check("redisson.replicated.nodeAddress")});
                this.setupBeanByConf(rsc, "redisson.replicated.");
                break;
            }
            case "sentinel": {
                SentinelServersConfig ssc2 = config.useSentinelServers();
                ssc2.addSentinelAddress(new String[]{this.conf.check("redisson.sentinel.sentinelAddress")});
                this.setupBeanByConf(ssc2, "redisson.sentinel.");
                break;
            }
            default: {
                throw Lang.noImplement();
            }
        }
        if (this.conf.has("redisson.codec")) {
            switch (this.conf.get("redisson.codec")) {
                case "jst": {
                    config.setCodec((Codec)new FstCodec());
                    break;
                }
                case "json-jackson": {
                    config.setCodec((Codec)new JsonJacksonCodec());
                    break;
                }
                case "msgpack-jackson": {
                    config.setCodec((Codec)new MsgPackJacksonCodec());
                    break;
                }
                case "cbor-jackson": {
                    config.setCodec((Codec)new CborJacksonCodec());
                    break;
                }
                case "smile-jackson": {
                    config.setCodec((Codec)new SmileJacksonCodec());
                    break;
                }
                case "kryo": {
                    config.setCodec((Codec)new KryoCodec());
                    break;
                }
                case "lz4": {
                    config.setCodec((Codec)new LZ4Codec());
                    break;
                }
                case "jdk": {
                    config.setCodec((Codec)new SerializationCodec());
                    break;
                }
                case "snappy": {
                    config.setCodec((Codec)new SnappyCodec());
                }
                case "snappy2": {
                    config.setCodec((Codec)new SnappyCodecV2());
                    break;
                }
                default: {
                    config.setCodec((Codec)new FstCodec());
                }
            }
        }
        return config;
    }

    @IocBean(name="redissonClient")
    public RedissonClient createRedissonClient(@Inject(value="refer:redissonConfig") Config redissonConfig) {
        return Redisson.create((Config)redissonConfig);
    }

    @IocBean(name="redissonRxClient")
    public RedissonRxClient createRedissonRxClient(@Inject(value="refer:redissonConfig") Config redissonConfig) {
        return Redisson.createRx((Config)redissonConfig);
    }

    @IocBean(name="redissonReactiveClient")
    public RedissonReactiveClient createRedissonReactive(@Inject(value="refer:redissonConfig") Config redissonConfig) {
        return Redisson.createReactive((Config)redissonConfig);
    }

    public void setupBeanByConf(Object obj, String prefix) {
        Field[] fields;
        Mirror mirror = Mirror.me(obj.getClass());
        for (Field field : fields = mirror.getFields()) {
            Class<?> klass;
            String key = prefix + field.getName();
            if (!this.conf.containsKey((Object)key) || !(klass = field.getType()).isPrimitive() && !String.class.equals(klass)) continue;
            mirror.setValue(obj, field, (Object)this.conf.get(key));
        }
    }
}

