/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.wkcache;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.nutz.aop.InterceptorChain;
import org.nutz.el.El;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.segment.CharSegment;
import org.nutz.lang.util.Context;
import org.nutz.lang.util.MethodParamNamesScaner;
import org.nutz.plugins.wkcache.AbstractWkcacheInterceptor;
import org.nutz.plugins.wkcache.annotation.CacheDefaults;
import org.nutz.plugins.wkcache.annotation.CacheResult;

@IocBean(singleton=false)
public class WkcacheResultInterceptor
extends AbstractWkcacheInterceptor {
    public void filter(InterceptorChain chain) throws Throwable {
        Object obj;
        byte[] bytes;
        int confLiveTime;
        CacheDefaults cacheDefaults;
        Method method = chain.getCallingMethod();
        CacheResult cacheResult = method.getAnnotation(CacheResult.class);
        String cacheKey = Strings.sNull((Object)cacheResult.cacheKey());
        String cacheName = Strings.sNull((Object)cacheResult.cacheName());
        int liveTime = cacheResult.cacheLiveTime();
        if (Strings.isBlank((CharSequence)cacheKey)) {
            cacheKey = method.getDeclaringClass().getName() + "." + method.getName() + "#" + Arrays.toString(chain.getArgs());
        } else {
            this.key = new CharSegment(cacheKey);
            if (this.key.hasKey()) {
                Context ctx = Lang.context();
                Object[] args = chain.getArgs();
                List names = MethodParamNamesScaner.getParamNames((Method)method);
                if (names != null) {
                    for (int i = 0; i < names.size() && i < args.length; ++i) {
                        ctx.set((String)names.get(i), args[i]);
                    }
                }
                ctx.set("args", (Object)args);
                Context _ctx = Lang.context();
                for (String key : this.key.keys()) {
                    _ctx.set(key, new El((CharSequence)key).eval(ctx));
                }
                cacheKey = this.key.render(_ctx).toString();
            } else {
                cacheKey = this.key.getOrginalString();
            }
        }
        if (Strings.isBlank((CharSequence)cacheName)) {
            cacheDefaults = method.getDeclaringClass().getAnnotation(CacheDefaults.class);
            String string = cacheName = cacheDefaults != null ? cacheDefaults.cacheName() : "wk";
        }
        if (liveTime == 0) {
            cacheDefaults = method.getDeclaringClass().getAnnotation(CacheDefaults.class);
            int n = liveTime = cacheDefaults != null ? cacheDefaults.cacheLiveTime() : 0;
        }
        if (this.getConf() != null && this.getConf().size() > 0 && (confLiveTime = this.getConf().getInt("wkcache." + cacheName, 0)) > 0) {
            liveTime = confLiveTime;
        }
        if ((bytes = this.redisService().get((cacheName + ":" + cacheKey).getBytes())) == null) {
            chain.doChain();
            obj = chain.getReturn();
            if (liveTime > 0) {
                this.redisService().setex((cacheName + ":" + cacheKey).getBytes(), liveTime, Lang.toBytes((Object)obj));
            } else {
                this.redisService().set((cacheName + ":" + cacheKey).getBytes(), Lang.toBytes((Object)obj));
            }
        } else {
            try {
                obj = Lang.fromBytes((byte[])bytes, method.getReturnType());
            }
            catch (Exception e) {
                this.redisService().del((cacheName + ":" + cacheKey).getBytes());
                obj = chain.getReturn();
                e.printStackTrace();
            }
        }
        chain.setReturnValue(obj);
    }
}

