/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.dubbo;

import org.nutz.boot.AppContext;
import org.nutz.boot.aware.AppContextAware;
import org.nutz.boot.ioc.IocLoaderProvider;
import org.nutz.integration.dubbo.DubboConfigIocLoader;
import org.nutz.integration.dubbo.DubboIocLoader;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class DubboIocLoaderStarter
implements IocLoaderProvider,
AppContextAware {
    private static final Log log = Logs.get();
    protected PropertiesProxy conf;
    protected Ioc ioc;
    protected AppContext appContext;

    public IocLoader getIocLoader() {
        if (this.conf.has("dubbo.xmlPaths")) {
            log.info((Object)"found dubbo.xmlPaths, use it");
            return new DubboIocLoader(Strings.splitIgnoreBlank((String)this.conf.get("dubbo.xmlPaths", "dubbo.xml")));
        }
        if (this.conf.getClass().getClassLoader().getResource("dubbo.xml") != null) {
            log.info((Object)"found dubbo.xml, use it");
            return new DubboIocLoader(new String[]{"dubbo.xml"});
        }
        log.debug((Object)"using dubbo configure from PropertiesProxy");
        if (Strings.isBlank((CharSequence)this.conf.get("dubbo.annotation.packages"))) {
            this.conf.put("dubbo.scan.basePackages", this.appContext.getPackage());
        }
        this.conf.putIfAbsent((Object)"dubbo.protocol.port", (Object)("" + this.appContext.getServerPort("dubbo.protocol.port", 8888)));
        return new DubboConfigIocLoader(this.ioc, this.conf);
    }

    public void setAppContext(AppContext appContext) {
        this.conf = appContext.getConf();
        this.ioc = appContext.getIoc();
        this.appContext = appContext;
    }
}

