/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.nutz.boot.AppContext;
import org.nutz.boot.annotation.PropDoc;
import org.nutz.boot.config.impl.AbstractConfigureLoader;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.stream.StringInputStream;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;

@IocBean
public class NacosConfigureLoader
extends AbstractConfigureLoader {
    private static final Log log = Logs.get();
    protected static final String NACOS_PRE = "nacos.config.";
    @PropDoc(value="Nacos\u8fdc\u7a0b\u5730\u5740", defaultValue="127.0.0.1:8848")
    public static final String NACOS_ADDR = "nacos.config.server-addr";
    @PropDoc(value="Nacos Data ID", defaultValue="nutzboot")
    public static final String NACOS_DATA_ID = "nacos.config.data-id";
    @PropDoc(value="Nacos\u5206\u7ec4", defaultValue="DEFAULT_GROUP")
    public static final String NACOS_GROUP = "nacos.config.group";
    @PropDoc(value="Nacos \u6570\u636e\u7c7b\u578b", defaultValue="properties")
    public static final String NACOS_DATA_TYPE = "nacos.config.data-type";
    @PropDoc(value="Nacos \u7f16\u7801\u65b9\u5f0f", defaultValue="")
    public static final String NACOS_ENCODE = "nacos.config.encode";
    @PropDoc(value="Nacos \u547d\u540d\u7a7a\u95f4ID", defaultValue="")
    public static final String NACOS_NAMESPACE = "nacos.config.namespace";
    @PropDoc(value="Nacos AccessKey", defaultValue="")
    public static final String NACOS_ACCESS_KEY = "nacos.config.access-key";
    @PropDoc(value="Nacos SecretKey", defaultValue="")
    public static final String NACOS_SECRET_KEY = "nacos.config.secret-key";
    @PropDoc(value="Nacos ContextPath", defaultValue="")
    public static final String NACOS_CONTEXT_PATH = "nacos.config.context-path";
    @PropDoc(value="Nacos \u96c6\u7fa4\u540d\u79f0", defaultValue="")
    public static final String NACOS_CLUSTER_NAME = "nacos.config.cluster-name";
    @PropDoc(value="Nacos \u6700\u5927\u91cd\u8bd5\u6b21\u6570", defaultValue="")
    public static final String NACOS_MAX_RETRY = "nacos.config.max-retry";
    @PropDoc(value="Nacos \u914d\u7f6e\u76d1\u542c\u957f\u8f6e\u8be2\u8d85\u65f6\u65f6\u95f4", defaultValue="")
    public static final String NACOS_CONFIG_LONG_POLL_TIMEOUT = "nacos.config.config-long-poll-timeout";
    @PropDoc(value="Nacos \u914d\u7f6e\u91cd\u8bd5\u65f6\u95f4", defaultValue="properties")
    public static final String NACOS_CONFIG_RETRY_TIME = "nacos.config.config-retry-time";
    @PropDoc(value="Nacos \u542f\u52a8\u65f6\u62c9\u53d6\u914d\u7f6e", defaultValue="false")
    public static final String NACOS_ENABLE_REMOTE_SYNC_CONFIG = "nacos.config.enable-remote-sync-config";
    @PropDoc(value="Nacos Endpoint", defaultValue="properties")
    public static final String NACOS_ENCODE_ENDPOINT = "nacos.config.endpoint";
    @Inject
    protected AppContext appContext;

    public PropertiesProxy get() {
        return this.conf;
    }

    private void setConfig(String content, String contentType, PropertiesProxy conf) {
        if ("json".equals(contentType)) {
            NutMap configMap = new NutMap(content);
            conf.putAll((Map)configMap);
        } else if ("xml".equals(contentType)) {
            Properties properties = new Properties();
            try {
                properties.loadFromXML((InputStream)new StringInputStream((CharSequence)content));
                for (Object key : properties.keySet()) {
                    conf.put(key.toString(), properties.get(key).toString());
                }
            }
            catch (IOException e) {
                throw Lang.makeThrow((String)"nacos config xml parse error!", (Object[])new Object[0]);
            }
        } else if ("properties".equals(contentType) || "txt".equals(contentType)) {
            PropertiesProxy propertiesProxy = new PropertiesProxy((InputStream)new StringInputStream((CharSequence)content));
            conf.putAll((Map)propertiesProxy);
        } else {
            throw Lang.makeThrow((String)"nacos.config.data_type is not found or not recognize\uff0conly json,xml and properties are support!", (Object[])new Object[0]);
        }
    }

    public void init() throws Exception {
        String dataId = this.conf.get(NACOS_DATA_ID, this.conf.get("nutz.application.name", "nutzboot"));
        String group = this.conf.get(NACOS_GROUP, "DEFAULT_GROUP");
        String dataType = this.conf.get(NACOS_DATA_TYPE, "properties");
        ConfigService configService = NacosFactory.createConfigService((Properties)this.getNacosConfigProperties());
        String configInfo = configService.getConfig(dataId, group, 5000L);
        log.debugf("get nacos config\uff1a%s", new Object[]{configInfo});
        if (Strings.isNotBlank((CharSequence)configInfo)) {
            this.setConfig(configInfo, dataType, this.conf);
        }
    }

    public Properties getNacosConfigProperties() {
        Properties properties = new Properties();
        properties.put("serverAddr", this.conf.get(NACOS_ADDR, "127.0.0.1:8848"));
        properties.put("encode", this.conf.get(NACOS_ENCODE, ""));
        properties.put("namespace", this.conf.get(NACOS_NAMESPACE, ""));
        properties.put("accessKey", this.conf.get(NACOS_ACCESS_KEY, ""));
        properties.put("secretKey", this.conf.get(NACOS_SECRET_KEY, ""));
        properties.put("contextPath", this.conf.get(NACOS_CONTEXT_PATH, ""));
        properties.put("clusterName", this.conf.get(NACOS_CLUSTER_NAME, ""));
        properties.put("maxRetry", this.conf.get(NACOS_MAX_RETRY, ""));
        properties.put("configLongPollTimeout", this.conf.get(NACOS_CONFIG_LONG_POLL_TIMEOUT, ""));
        properties.put("configRetryTime", this.conf.get(NACOS_CONFIG_RETRY_TIME, ""));
        properties.put("enableRemoteSyncConfig", this.conf.get(NACOS_ENABLE_REMOTE_SYNC_CONFIG, ""));
        String endpoint = this.conf.get(NACOS_ENCODE_ENDPOINT, "");
        if (endpoint.contains(":")) {
            int index = endpoint.indexOf(":");
            properties.put("endpoint", endpoint.substring(0, index));
            properties.put("endpointPort", endpoint.substring(index + 1));
        } else {
            properties.put("endpoint", endpoint);
        }
        return properties;
    }
}

