/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.composable;

import reactor.core.composable.Composable;
import reactor.event.Event;
import reactor.event.support.CallbackEvent;
import reactor.function.Consumer;

public class Deferred<T, C extends Composable<T>>
implements Consumer<T> {
    private final C composable;

    public Deferred(C composable) {
        this.composable = composable;
    }

    @Override
    public void accept(Throwable error) {
        ((Composable)this.composable).notifyError(error);
    }

    @Override
    public void accept(T value) {
        ((Composable)this.composable).notifyValue(Event.wrap(value));
    }

    public void acceptEvent(Event<T> value) {
        ((Composable)this.composable).notifyValue(value);
    }

    public void accept(T value, Consumer<Object> callback) {
        ((Composable)this.composable).notifyValue(new CallbackEvent<T>(value, callback));
    }

    public C compose() {
        return this.composable;
    }
}

