/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.composable.spec;

import reactor.core.Environment;
import reactor.core.composable.Promise;
import reactor.core.composable.spec.DeferredPromiseSpec;
import reactor.core.spec.support.DispatcherComponentSpec;
import reactor.event.dispatch.Dispatcher;
import reactor.function.Supplier;
import reactor.util.Assert;

public final class PromiseSpec<T>
extends DispatcherComponentSpec<PromiseSpec<T>, Promise<T>> {
    private T value;
    private Supplier<T> valueSupplier;
    private Throwable error;

    public PromiseSpec<T> success(T value) {
        Assert.isNull(this.error, "Cannot set both a value and an error. Use one or the other.");
        Assert.isNull(this.valueSupplier, "Cannot set both a value and a Supplier. Use one or the other.");
        this.value = value;
        return this;
    }

    public PromiseSpec<T> supply(Supplier<T> valueSupplier) {
        Assert.isNull(this.error, "Cannot set both an error and a Supplier. Use one or the other.");
        Assert.isNull(this.value, "Cannot set both a value and a Supplier. Use one or the other.");
        this.valueSupplier = valueSupplier;
        return this;
    }

    public PromiseSpec<T> error(Throwable error) {
        Assert.isNull(this.value, "Cannot set both a value and an error. Use one or the other.");
        Assert.isNull(this.valueSupplier, "Cannot set both an error and a Supplier. Use one or the other.");
        this.error = error;
        return this;
    }

    @Override
    protected Promise<T> configure(Dispatcher dispatcher, Environment env) {
        if (this.value != null) {
            return new Promise<T>(this.value, dispatcher, env);
        }
        if (this.valueSupplier != null) {
            return new Promise<T>(this.valueSupplier, dispatcher, env);
        }
        if (this.error != null) {
            return new Promise(this.error, dispatcher, env);
        }
        throw new IllegalStateException("A success value/supplier or error reason must be provided. Use " + DeferredPromiseSpec.class.getSimpleName() + " to create a deferred promise");
    }
}

