/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.composable.spec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import reactor.core.Environment;
import reactor.core.composable.Composable;
import reactor.core.composable.Deferred;
import reactor.core.composable.Promise;
import reactor.core.composable.Stream;
import reactor.core.composable.spec.DeferredPromiseSpec;
import reactor.core.composable.spec.DeferredStreamSpec;
import reactor.core.composable.spec.PromiseSpec;
import reactor.event.dispatch.Dispatcher;
import reactor.function.Supplier;

public abstract class Promises {
    public static <T> Deferred<T, Promise<T>> defer(Environment env) {
        return Promises.defer(env, env.getDefaultDispatcher());
    }

    public static <T> Deferred<T, Promise<T>> defer(Environment env, String dispatcher) {
        return Promises.defer(env, env.getDispatcher(dispatcher));
    }

    public static <T> Deferred<T, Promise<T>> defer(Environment env, Dispatcher dispatcher) {
        return (Deferred)((DeferredPromiseSpec)((DeferredPromiseSpec)new DeferredPromiseSpec().env(env)).dispatcher(dispatcher)).get();
    }

    public static <T> DeferredPromiseSpec<T> defer() {
        return new DeferredPromiseSpec();
    }

    public static <T> PromiseSpec<T> task(Supplier<T> supplier) {
        return new PromiseSpec<T>().supply(supplier);
    }

    public static <T> PromiseSpec<T> success(T value) {
        return new PromiseSpec<T>().success(value);
    }

    public static <T> PromiseSpec<T> error(Throwable error) {
        return new PromiseSpec().error(error);
    }

    public static <T> Promise<List<T>> when(Promise<T> ... promises) {
        return Promises.when(Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> when(Deferred<T, Promise<T>> ... promises) {
        return Promises.when(Promises.deferredToPromises(promises));
    }

    public static <T> Promise<List<T>> when(Collection<? extends Promise<T>> promises) {
        Stream deferredStream = (Stream)((Deferred)((DeferredStreamSpec)new DeferredStreamSpec().synchronousDispatcher()).batchSize(promises.size()).get()).compose();
        Stream aggregatedStream = deferredStream.collect();
        Promise resultPromise = (Promise)((Deferred)((DeferredPromiseSpec)new DeferredPromiseSpec().synchronousDispatcher()).link(aggregatedStream).get()).compose();
        aggregatedStream.consume((Composable)resultPromise);
        for (Promise<T> promise : promises) {
            promise.consume((Composable)deferredStream);
        }
        return resultPromise;
    }

    public static <T> Promise<T> any(Deferred<T, Promise<T>> ... promises) {
        return Promises.any(Promises.deferredToPromises(promises));
    }

    public static <T> Promise<T> any(Promise<T> ... promises) {
        return Promises.any(Arrays.asList(promises));
    }

    public static <T> Promise<T> any(Collection<? extends Promise<T>> promises) {
        Stream deferredStream = (Stream)((Deferred)((DeferredStreamSpec)new DeferredStreamSpec().synchronousDispatcher()).batchSize(promises.size()).get()).compose();
        Stream firstStream = deferredStream.first();
        Promise resultPromise = (Promise)((Deferred)((DeferredPromiseSpec)new DeferredPromiseSpec().synchronousDispatcher()).link(firstStream).get()).compose();
        firstStream.consume((Composable)resultPromise);
        for (Promise<T> promise : promises) {
            promise.consume((Composable)deferredStream);
        }
        return resultPromise;
    }

    private static <T> List<Promise<T>> deferredToPromises(Deferred<T, Promise<T>> ... promises) {
        ArrayList<Promise<T>> promiseList = new ArrayList<Promise<T>>();
        for (Deferred<T, Promise<T>> deferred : promises) {
            promiseList.add(deferred.compose());
        }
        return promiseList;
    }
}

