/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dynamic.reflect;

import java.lang.reflect.Method;
import reactor.core.dynamic.annotation.On;
import reactor.core.dynamic.reflect.MethodSelectorResolver;
import reactor.core.dynamic.reflect.support.AnnotationUtils;
import reactor.core.dynamic.reflect.support.MethodNameUtils;
import reactor.event.selector.ObjectSelector;
import reactor.event.selector.Selector;

public class SimpleMethodSelectorResolver
implements MethodSelectorResolver {
    @Override
    public Selector apply(Method method) {
        On onAnno = AnnotationUtils.find(method, On.class);
        String sel = null != onAnno ? onAnno.value() : MethodNameUtils.methodNameToSelectorName(method.getName());
        return !"".equals(sel) ? new ObjectSelector<String>(sel) : null;
    }

    @Override
    public boolean supports(Method method) {
        return method.getDeclaringClass() != Object.class && !method.getName().contains("$");
    }
}

