/*
 * Decompiled with CFR 0.152.
 */
package reactor.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import reactor.function.Consumer;
import reactor.tuple.Tuple;
import reactor.tuple.Tuple2;
import reactor.util.Assert;
import reactor.util.UUIDUtils;

public class Event<T>
implements Serializable {
    private static final long serialVersionUID = -2476263092040373361L;
    private volatile UUID id;
    private volatile Headers headers;
    private volatile Object replyTo;
    private volatile Object key;
    private volatile T data;
    private final transient Consumer<Throwable> errorConsumer;

    public Event(Headers headers, T data) {
        this.headers = headers;
        this.data = data;
        this.errorConsumer = null;
    }

    public Event(Headers headers, T data, Consumer<Throwable> errorConsumer) {
        this.headers = headers;
        this.data = data;
        this.errorConsumer = errorConsumer;
    }

    public Event(T data) {
        this.data = data;
        this.errorConsumer = null;
    }

    public static <T> Event<T> wrap(T obj) {
        return new Event<T>(obj);
    }

    public static <T> Event<T> wrap(T obj, Object replyToKey) {
        return new Event<T>(obj).setReplyTo(replyToKey);
    }

    public synchronized UUID getId() {
        if (null == this.id) {
            this.id = UUIDUtils.create();
        }
        return this.id;
    }

    public synchronized Headers getHeaders() {
        if (null == this.headers) {
            this.headers = new Headers();
        }
        return this.headers;
    }

    public Object getReplyTo() {
        return this.replyTo;
    }

    public Event<T> setReplyTo(Object replyTo) {
        Assert.notNull(replyTo, "ReplyTo cannot be null.");
        this.replyTo = replyTo;
        return this;
    }

    public Object getKey() {
        return this.key;
    }

    public Event<T> setKey(Object key) {
        this.key = key;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public Event<T> setData(T data) {
        this.data = data;
        return this;
    }

    public Consumer<Throwable> getErrorConsumer() {
        return this.errorConsumer;
    }

    public Event<T> copy() {
        return this.copy(this.data);
    }

    public <E> Event<E> copy(E data) {
        if (null != this.replyTo) {
            return new Event<E>(this.headers, data, this.errorConsumer).setReplyTo(this.replyTo);
        }
        return new Event<E>(this.headers, data, this.errorConsumer);
    }

    public void consumeError(Throwable throwable) {
        if (null != this.errorConsumer) {
            this.errorConsumer.accept(throwable);
        }
    }

    public String toString() {
        return "Event{id=" + this.id + ", headers=" + this.headers + ", replyTo=" + this.replyTo + ", data=" + this.data + '}';
    }

    public static class Headers
    implements Serializable,
    Iterable<Tuple2<String, String>> {
        public static final String ORIGIN = "x-reactor-origin";
        private static final long serialVersionUID = 4984692586458514948L;
        private final Object monitor = UUIDUtils.create();
        private final Map<String, String> headers;

        private Headers(boolean sealed, Map<String, String> headers) {
            TreeMap<String, String> copy = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            this.copyHeaders(headers, copy);
            this.headers = sealed ? Collections.unmodifiableMap(copy) : copy;
        }

        public Headers(Map<String, String> headers) {
            this(false, headers);
        }

        public Headers() {
            this(false, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Headers setAll(Map<String, String> headers) {
            if (null == headers || headers.isEmpty()) {
                return this;
            }
            Object object = this.monitor;
            synchronized (object) {
                this.copyHeaders(headers, this.headers);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Headers set(String name, String value) {
            Object object = this.monitor;
            synchronized (object) {
                this.setHeader(name, value, this.headers);
            }
            return this;
        }

        public Headers setOrigin(UUID id) {
            String idString = id == null ? null : id.toString();
            return this.setOrigin(idString);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Headers setOrigin(String id) {
            Object object = this.monitor;
            synchronized (object) {
                this.setHeader(ORIGIN, id, this.headers);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getOrigin() {
            Object object = this.monitor;
            synchronized (object) {
                return this.headers.get(ORIGIN);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String get(String name) {
            Object object = this.monitor;
            synchronized (object) {
                return this.headers.get(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(String name) {
            Object object = this.monitor;
            synchronized (object) {
                return this.headers.containsKey(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, String> asMap() {
            Object object = this.monitor;
            synchronized (object) {
                return Collections.unmodifiableMap(this.headers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Headers readOnly() {
            Object object = this.monitor;
            synchronized (object) {
                return new Headers(true, this.headers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<Tuple2<String, String>> iterator() {
            Object object = this.monitor;
            synchronized (object) {
                ArrayList<Tuple2<String, String>> headers = new ArrayList<Tuple2<String, String>>(this.headers.size());
                for (Map.Entry<String, String> header : this.headers.entrySet()) {
                    headers.add(Tuple.of(header.getKey(), header.getValue()));
                }
                return Collections.unmodifiableList(headers).iterator();
            }
        }

        private void copyHeaders(Map<String, String> source, Map<String, String> target) {
            if (source != null) {
                for (Map.Entry<String, String> entry : source.entrySet()) {
                    this.setHeader(entry.getKey(), entry.getValue(), target);
                }
            }
        }

        private void setHeader(String name, String value, Map<String, String> target) {
            if (value == null) {
                target.remove(name);
            } else {
                target.put(name, value);
            }
        }
    }
}

